/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.rwt.internal.resources.ResourceManagerImpl;
import org.eclipse.rwt.resources.IResourceManager;

public final class ResourceUtil {
    private static final String ONE_LINE_COMMENT = "//";
    private static final String MULTI_LINE_COMMENT_START = "/*";
    private static final String MULTI_LINE_COMMENT_END = "*/";
    private static final String NEWLINE_MAC = "\r";
    private static final String NEWLINE_UNIX = "\n";
    private static final String NEWLINE_WIN = "\r\n";
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char NO_QUOTE = '-';
    private static final char BACKSLASH = '\\';
    private static final char LINE_FEED = '\r';
    private static final char CARRIAGE_RETURN = '\n';
    private static ByteArrayOutputStream jsConcatenationBuffer = null;
    static /* synthetic */ Class class$0;

    static int[] read(String name, String charset, boolean compress) throws IOException {
        int[] result = charset != null ? ResourceUtil.readText(name, charset, compress) : ResourceUtil.readBinary(name);
        return result;
    }

    static int[] read(InputStream is, String charset, boolean compress) throws IOException {
        int[] result = charset != null ? ResourceUtil.readText(is, charset, compress) : ResourceUtil.readBinary(is);
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void write(File toWrite, int[] content) throws IOException {
        FileOutputStream fos = new FileOutputStream(toWrite);
        try {
            BufferedOutputStream out = new BufferedOutputStream(fos);
            try {
                int i = 0;
                while (i < content.length) {
                    ((OutputStream)out).write(content[i]);
                    if (jsConcatenationBuffer != null && toWrite.getName().endsWith("js")) {
                        jsConcatenationBuffer.write(content[i]);
                        if (i == content.length - 1) {
                            jsConcatenationBuffer.write(10);
                        }
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                ((OutputStream)out).close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                ((OutputStream)out).close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            fos.close();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        fos.close();
    }

    public static void startJsConcatenation() {
        jsConcatenationBuffer = new ByteArrayOutputStream();
    }

    static String getJsConcatenationContentAsString() {
        String result = "";
        try {
            result = jsConcatenationBuffer.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        jsConcatenationBuffer = null;
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[] readText(String name, String charset, boolean compress) throws IOException {
        int[] result;
        InputStream is = ResourceUtil.openStream(name);
        try {
            result = ResourceUtil.readText(is, charset, compress);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            is.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        is.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int[] readText(InputStream is, String charset, boolean compress) throws UnsupportedEncodingException, IOException {
        byte[] bytes;
        StringBuffer buffer = new StringBuffer();
        InputStreamReader reader = new InputStreamReader(is, charset);
        BufferedReader br = new BufferedReader(reader);
        try {
            int character = br.read();
            while (character != -1) {
                buffer.append((char)character);
                character = br.read();
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            br.close();
            throw throwable;
        }
        {
            Object var7_11 = null;
        }
        br.close();
        if (compress) {
            ResourceUtil.compress(buffer);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
            try {
                osw.write(buffer.toString());
                osw.flush();
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                osw.close();
                throw throwable;
            }
            {
                Object var9_14 = null;
            }
            osw.close();
            bytes = baos.toByteArray();
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            baos.close();
            throw throwable;
        }
        {
            Object var11_18 = null;
        }
        baos.close();
        int[] result = new int[bytes.length];
        int i = 0;
        while (i < result.length) {
            result[i] = bytes[i] & 0xFF;
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[] readBinary(String name) throws IOException {
        int[] result;
        InputStream is = ResourceUtil.openStream(name);
        try {
            result = ResourceUtil.readBinary(is);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            is.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        is.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int[] readBinary(InputStream is) throws IOException {
        int[] result;
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            bis.mark(Integer.MAX_VALUE);
            result = new int[ResourceUtil.getAvailableCount(bis)];
            int i = 0;
            while (i < result.length) {
                result[i] = bis.read();
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            bis.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        bis.close();
        return result;
    }

    private static int getAvailableCount(BufferedInputStream bis) throws IOException {
        int result = 0;
        int streamElement = 0;
        while (streamElement != -1) {
            streamElement = bis.read();
            if (streamElement == -1) continue;
            ++result;
        }
        bis.reset();
        return result;
    }

    private static InputStream openStream(String name) throws IOException {
        ClassLoader loader;
        URL resource;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.resources.ResourceManagerImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (loader = clazz.getClassLoader()).getResource(name)) == null) {
            IResourceManager manager = ResourceManagerImpl.getInstance();
            resource = manager.getResource(name);
        }
        if (resource == null) {
            throw new IOException("Resource to read not found: " + name);
        }
        URLConnection con = resource.openConnection();
        con.setUseCaches(false);
        InputStream result = con.getInputStream();
        return result;
    }

    static void compress(StringBuffer javaScript) {
        ResourceUtil.removeOneLineComments(javaScript);
        ResourceUtil.removeMultiLineComments(javaScript);
        ResourceUtil.removeMultipleBlanks(javaScript);
        ResourceUtil.replace(javaScript, " = ", "=");
        ResourceUtil.replace(javaScript, " == ", "==");
        ResourceUtil.replace(javaScript, " === ", "===");
        ResourceUtil.replace(javaScript, " + ", "+");
        ResourceUtil.replace(javaScript, " - ", "-");
        ResourceUtil.replace(javaScript, " * ", "*");
        ResourceUtil.replace(javaScript, " / ", "/");
        ResourceUtil.replace(javaScript, " > ", ">");
        ResourceUtil.replace(javaScript, " < ", "<");
        ResourceUtil.replace(javaScript, " <= ", "<=");
        ResourceUtil.replace(javaScript, " >= ", ">=");
        ResourceUtil.replace(javaScript, " != ", "!=");
        ResourceUtil.replace(javaScript, " : ", ":");
        ResourceUtil.replace(javaScript, " && ", "&&");
        ResourceUtil.replace(javaScript, " || ", "||");
        ResourceUtil.replace(javaScript, " ? ", "?");
        ResourceUtil.removeLeadingBlanks(javaScript);
        ResourceUtil.removeMultipleNewLines(javaScript, NEWLINE_WIN);
        ResourceUtil.removeMultipleNewLines(javaScript, NEWLINE_UNIX);
        ResourceUtil.removeMultipleNewLines(javaScript, NEWLINE_MAC);
        ResourceUtil.replace(javaScript, "( ", "(");
        ResourceUtil.replace(javaScript, " )", ")");
        ResourceUtil.replace(javaScript, "} ", "}");
        ResourceUtil.replace(javaScript, " {", "{");
        ResourceUtil.replace(javaScript, " }", "}");
        ResourceUtil.replace(javaScript, "{ ", "{");
        ResourceUtil.replace(javaScript, "[ ", "[");
        ResourceUtil.replace(javaScript, " ]", "]");
        ResourceUtil.replace(javaScript, ", ", ",");
        ResourceUtil.replace(javaScript, "; ", ";");
        ResourceUtil.replace(javaScript, "\r\n}", "}");
        ResourceUtil.replace(javaScript, "\n}", "}");
        ResourceUtil.replace(javaScript, "\r}", "}");
        ResourceUtil.replace(javaScript, "\r\n{", "{");
        ResourceUtil.replace(javaScript, "\n{", "{");
        ResourceUtil.replace(javaScript, "\r{", "{");
        ResourceUtil.replace(javaScript, "}\r\n", "}");
        ResourceUtil.replace(javaScript, "}\n", "}");
        ResourceUtil.replace(javaScript, "}\r", "}");
        ResourceUtil.replace(javaScript, "{\r\n", "{");
        ResourceUtil.replace(javaScript, "{\n", "{");
        ResourceUtil.replace(javaScript, "{\r", "{");
        ResourceUtil.replace(javaScript, "\r\n&&", "&&");
        ResourceUtil.replace(javaScript, "\n&&", "&&");
        ResourceUtil.replace(javaScript, "\r&&", "&&");
        ResourceUtil.replace(javaScript, "\r\n||", "||");
        ResourceUtil.replace(javaScript, "\n||", "||");
        ResourceUtil.replace(javaScript, "\r||", "||");
        ResourceUtil.replace(javaScript, "\r\n=", "=");
        ResourceUtil.replace(javaScript, "\n=", "=");
        ResourceUtil.replace(javaScript, "\r=", "=");
        ResourceUtil.replace(javaScript, "\r\n+", "+");
        ResourceUtil.replace(javaScript, "\n+", "+");
        ResourceUtil.replace(javaScript, "\r+", "+");
        ResourceUtil.replace(javaScript, "\r\n-", "-");
        ResourceUtil.replace(javaScript, "\n-", "-");
        ResourceUtil.replace(javaScript, "\r-", "-");
        ResourceUtil.replace(javaScript, "\r\n:", ":");
        ResourceUtil.replace(javaScript, "\n:", ":");
        ResourceUtil.replace(javaScript, "\r:", ":");
        ResourceUtil.replace(javaScript, "\r\n?", "?");
        ResourceUtil.replace(javaScript, "\n?", "?");
        ResourceUtil.replace(javaScript, "\r?", "?");
        ResourceUtil.replace(javaScript, ",\r\n", ",");
        ResourceUtil.replace(javaScript, ",\n", ",");
        ResourceUtil.replace(javaScript, ",\r", ",");
        ResourceUtil.replace(javaScript, ";\r\n", ";");
        ResourceUtil.replace(javaScript, ";\n", ";");
        ResourceUtil.replace(javaScript, ";\r", ";");
        ResourceUtil.replace(javaScript, ":\r\n", ":");
        ResourceUtil.replace(javaScript, ":\n", ":");
        ResourceUtil.replace(javaScript, ":\r", ":");
    }

    static void replace(StringBuffer javaScript, String strToFind, String strToReplace) {
        int index = javaScript.indexOf(strToFind, 0);
        while (index != -1) {
            if (!ResourceUtil.isInsideString(javaScript, index)) {
                javaScript.replace(index, index + strToFind.length(), strToReplace);
            } else {
                index += strToFind.length();
            }
            index = javaScript.indexOf(strToFind, index + strToReplace.length());
        }
    }

    static void removeOneLineComments(StringBuffer javaScript) {
        int commentStart = javaScript.indexOf(ONE_LINE_COMMENT, 0);
        while (commentStart != -1) {
            int lineEnd = ResourceUtil.nextNewLine(javaScript, commentStart);
            if (!ResourceUtil.isInsideString(javaScript, commentStart)) {
                javaScript.delete(commentStart, lineEnd);
            } else {
                commentStart += 2;
            }
            commentStart = javaScript.indexOf(ONE_LINE_COMMENT, commentStart);
        }
    }

    static int nextNewLine(StringBuffer buffer, int currentPos) {
        int result = buffer.indexOf(NEWLINE_WIN, currentPos);
        if (result == -1) {
            result = buffer.indexOf(NEWLINE_UNIX, currentPos);
        }
        if (result == -1) {
            result = buffer.indexOf(NEWLINE_MAC, currentPos);
        }
        if (result == -1) {
            result = buffer.length();
        }
        return result;
    }

    static void removeMultiLineComments(StringBuffer javaScript) {
        int index = javaScript.indexOf(MULTI_LINE_COMMENT_START);
        while (index != -1) {
            int end = javaScript.indexOf(MULTI_LINE_COMMENT_END);
            if (end != -1) {
                if (!ResourceUtil.isInsideString(javaScript, index)) {
                    javaScript.delete(index, end + MULTI_LINE_COMMENT_END.length());
                } else {
                    index += 2;
                }
            }
            index = javaScript.indexOf(MULTI_LINE_COMMENT_START, index);
        }
    }

    static void removeMultipleBlanks(StringBuffer javaScript) {
        int index = javaScript.indexOf("  ");
        while (index != -1) {
            if (!ResourceUtil.isInsideString(javaScript, index)) {
                javaScript.delete(index, index + 1);
            } else {
                ++index;
            }
            index = javaScript.indexOf("  ", index);
        }
    }

    static void removeLeadingBlanks(StringBuffer javaScript) {
        int index = javaScript.indexOf(" ");
        while (index != -1) {
            int prev = 45;
            if (index > 0) {
                prev = javaScript.charAt(index - 1);
            }
            if (prev == 13 || prev == 10 || index == 0) {
                javaScript.delete(index, index + 1);
            } else {
                ++index;
            }
            index = javaScript.indexOf(" ", index);
        }
    }

    static void removeMultipleNewLines(StringBuffer javaScript, String newline) {
        String doubleNewLine = String.valueOf(newline) + newline;
        int index = javaScript.indexOf(doubleNewLine);
        while (index != -1) {
            javaScript.delete(index, index + newline.length());
            index = javaScript.indexOf(doubleNewLine, index);
        }
    }

    static boolean isInsideString(StringBuffer javaScript, int position) {
        String line = ResourceUtil.getLineAtPosition(javaScript, position);
        int pos = ResourceUtil.getPositionInLine(javaScript, position);
        int quoteChar = 45;
        int prevChar = 45;
        int i = 0;
        while (i < pos) {
            char ch = line.charAt(i);
            if (ch == '\"' && quoteChar == 45) {
                quoteChar = 34;
            } else if (ch == '\"' && quoteChar == 34 && prevChar != 92) {
                quoteChar = 45;
            } else if (ch == '\'' && quoteChar == 45) {
                quoteChar = 39;
            } else if (ch == '\'' && quoteChar == 39 && prevChar != 92) {
                quoteChar = 45;
            }
            prevChar = ch;
            ++i;
        }
        return quoteChar != 45;
    }

    static String getLineAtPosition(StringBuffer javaScript, int position) {
        String line = "";
        if (position >= 0 && position < javaScript.length()) {
            int start = position;
            int end = position;
            char ch = javaScript.charAt(start);
            while (ch != '\r' && ch != '\n' && start > 0) {
                ch = javaScript.charAt(--start);
            }
            ch = javaScript.charAt(end);
            while (ch != '\r' && ch != '\n' && end < javaScript.length()) {
                ch = javaScript.charAt(end);
                ++end;
            }
            line = javaScript.substring(start, end);
            if (line.startsWith(NEWLINE_MAC) || line.startsWith(NEWLINE_UNIX)) {
                line = line.substring(1);
            }
            if (line.endsWith(NEWLINE_MAC) || line.endsWith(NEWLINE_UNIX)) {
                line = line.substring(0, line.length() - 1);
            }
        }
        return line;
    }

    static int getPositionInLine(StringBuffer javaScript, int position) {
        int pos = 0;
        if (position >= 0 && position < javaScript.length()) {
            int start = position;
            char ch = javaScript.charAt(start);
            while (ch != '\r' && ch != '\n' && start > 0) {
                ++pos;
                ch = javaScript.charAt(--start);
            }
            if (ch == '\r' || ch == '\n') {
                --pos;
            }
        }
        return pos;
    }

    private ResourceUtil() {
    }
}

