/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.branding.AbstractBranding;
import org.eclipse.rwt.internal.branding.BrandingUtil;
import org.eclipse.rwt.internal.lifecycle.HtmlResponseWriter;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.service.RWTStartupPageConfigurer;
import org.eclipse.rwt.internal.service.StartupPageTemplateHolder;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.ThemeUtil;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.internal.util.URLHelper;

public final class StartupPage {
    public static IStartupPageConfigurer configurer = new RWTStartupPageConfigurer();

    static void send() throws IOException {
        if (configurer.isModifiedSince()) {
            StartupPage.render();
        } else {
            AbstractBranding branding = BrandingUtil.findBranding();
            if (branding.getThemeId() != null) {
                ThemeUtil.setCurrentThemeId(branding.getThemeId());
            }
        }
    }

    private static String getBgImage() {
        QxImage image;
        String resourceName;
        String result = "";
        QxType cssValue = ThemeUtil.getCssValue("Display", "background-image", SimpleSelector.DEFAULT);
        if (cssValue instanceof QxImage && (resourceName = (image = (QxImage)cssValue).getResourceName()) != null) {
            result = RWT.getResourceManager().getLocation(resourceName);
        }
        return result;
    }

    private static void render() throws IOException {
        ContextProvider.getResponse().setContentType("text/html");
        StartupPageTemplateHolder template = configurer.getTemplate();
        template.replace(StartupPageTemplateHolder.VAR_BACKGROUND_IMAGE, StartupPage.getBgImage());
        template.replace(StartupPageTemplateHolder.VAR_SERVLET, URLHelper.getSerlvetName());
        template.replace(StartupPageTemplateHolder.VAR_ENTRY_POINT, EncodingUtil.encodeHTMLEntities(StartupPage.getEntryPoint()));
        String[] tokens = template.getTokens();
        int i = 0;
        while (i < tokens.length) {
            if (tokens[i] != null) {
                StartupPage.getResponseWriter().append(tokens[i]);
            }
            ++i;
        }
    }

    private static String getEntryPoint() {
        HttpServletRequest request = ContextProvider.getRequest();
        String result = request.getParameter("startup");
        if (result == null) {
            result = "default";
        }
        return result;
    }

    private static HtmlResponseWriter getResponseWriter() {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        return stateInfo.getResponseWriter();
    }

    public static interface IStartupPageConfigurer {
        public StartupPageTemplateHolder getTemplate() throws IOException;

        public boolean isModifiedSince();
    }
}

