/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rwt.internal.theme.css.StyleSheet;

public final class ThemeCssValuesMap {
    private final Map valuesMap = new HashMap();

    public ThemeCssValuesMap(StyleSheet styleSheet, ThemeableWidget[] themeableWidgets) {
        this.extractValues(styleSheet, themeableWidgets);
    }

    public ConditionalValue[] getValues(String elementName, String propertyName) {
        PropertyKey propertyKey = new PropertyKey(elementName, propertyName);
        ConditionalValue[] result = (ConditionalValue[])this.valuesMap.get(propertyKey);
        if (result == null) {
            PropertyKey wildcardKey = new PropertyKey("*", propertyName);
            result = (ConditionalValue[])this.valuesMap.get(wildcardKey);
        }
        return result;
    }

    public QxType[] getAllValues() {
        HashSet<QxType> resultSet = new HashSet<QxType>();
        Iterator iterator = this.valuesMap.values().iterator();
        while (iterator.hasNext()) {
            ConditionalValue[] condValues = (ConditionalValue[])iterator.next();
            int i = 0;
            while (i < condValues.length) {
                ConditionalValue condValue = condValues[i];
                resultSet.add(condValue.value);
                ++i;
            }
        }
        QxType[] result = new QxType[resultSet.size()];
        resultSet.toArray(result);
        return result;
    }

    private void extractValues(StyleSheet styleSheet, ThemeableWidget[] themeableWidgets) {
        int i = 0;
        while (i < themeableWidgets.length) {
            ThemeableWidget themeableWidget = themeableWidgets[i];
            this.extractValuesForWidget(styleSheet, themeableWidget);
            ++i;
        }
    }

    private void extractValuesForWidget(StyleSheet styleSheet, ThemeableWidget themeableWidget) {
        IThemeCssElement[] elements = themeableWidget.elements;
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                IThemeCssElement element = elements[i];
                String elementName = element.getName();
                String[] properties = element.getProperties();
                int j = 0;
                while (j < properties.length) {
                    String propertyName = properties[j];
                    PropertyKey key = new PropertyKey(elementName, propertyName);
                    ConditionalValue[] values = styleSheet.getValues(elementName, propertyName);
                    ConditionalValue[] filteredValues = this.filterValues(values, element);
                    this.valuesMap.put(key, filteredValues);
                    ++j;
                }
                ++i;
            }
        }
    }

    private ConditionalValue[] filterValues(ConditionalValue[] values, IThemeCssElement element) {
        ArrayList<ConditionalValue> resultList = new ArrayList<ConditionalValue>();
        Object[] latestConstraint = null;
        int j = 0;
        while (j < values.length) {
            ConditionalValue value = values[j];
            if (!Arrays.equals(latestConstraint, value.constraints) && ThemeCssValuesMap.matches(element, value.constraints)) {
                resultList.add(value);
                latestConstraint = value.constraints;
            }
            ++j;
        }
        ConditionalValue[] result = new ConditionalValue[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    private static boolean matches(IThemeCssElement element, String[] constraints) {
        boolean passed = true;
        if (!"*".equals(element.getName())) {
            int k = 0;
            while (k < constraints.length && passed) {
                String constraint = constraints[k];
                if (constraint.charAt(0) == ':') {
                    passed &= ThemeCssValuesMap.contains(element.getStates(), constraint.substring(1));
                } else if (constraint.charAt(0) == '[') {
                    passed &= ThemeCssValuesMap.contains(element.getStyles(), constraint.substring(1));
                }
                ++k;
            }
        }
        return passed;
    }

    private static boolean contains(String[] elements, String string) {
        boolean result = false;
        int i = 0;
        while (i < elements.length && !result) {
            if (string.equals(elements[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private static class PropertyKey {
        private final String element;
        private final String property;
        private final int hashCode;

        public PropertyKey(String element, String property) {
            this.element = element;
            this.property = property;
            this.hashCode = element.hashCode() ^ property.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (obj != null && obj.getClass() == this.getClass()) {
                PropertyKey other = (PropertyKey)obj;
                result = this.element.equals(other.element) && this.property.equals(other.property);
            } else {
                result = false;
            }
            return result;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

