/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.SimpleSelector;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeCssValuesMap;
import org.eclipse.rwt.internal.theme.ThemeManager;
import org.eclipse.rwt.internal.theme.ValueSelector;
import org.eclipse.rwt.internal.theme.css.ConditionalValue;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.widgets.Widget;

public final class ThemeUtil {
    private static final String THEME_URL_PARM = "theme";
    private static final String CURR_THEME_ATTR = "org.eclipse.rap.theme.current";

    public static String[] getAvailableThemeIds() {
        return ThemeManager.getInstance().getRegisteredThemeIds();
    }

    public static String getCurrentThemeId() {
        ThemeManager manager = ThemeManager.getInstance();
        ISessionStore session = ContextProvider.getSession();
        String result = ContextProvider.getRequest().getParameter(THEME_URL_PARM);
        if (result != null && manager.hasTheme(result)) {
            session.setAttribute(CURR_THEME_ATTR, result);
        } else {
            result = (String)session.getAttribute(CURR_THEME_ATTR);
        }
        if (result == null) {
            result = "org.eclipse.rap.rwt.theme.Default";
        }
        return result;
    }

    public static void setCurrentThemeId(String themeId) {
        if (!ThemeManager.getInstance().hasTheme(themeId)) {
            throw new IllegalArgumentException("Illegal theme id: " + themeId);
        }
        ContextProvider.getSession().setAttribute(CURR_THEME_ATTR, themeId);
    }

    public static Theme getTheme() {
        return ThemeManager.getInstance().getTheme(ThemeUtil.getCurrentThemeId());
    }

    public static Theme getDefaultTheme() {
        ThemeManager themeManager = ThemeManager.getInstance();
        return themeManager.getTheme("org.eclipse.rap.rwt.theme.Default");
    }

    public static QxType getCssValue(String cssElement, String cssProperty, SimpleSelector selector) {
        return ThemeUtil.getCssValue(cssElement, cssProperty, selector, null);
    }

    public static QxType getCssValue(String cssElement, String cssProperty, ValueSelector selector, Widget widget) {
        Theme theme = ThemeUtil.getTheme();
        ThemeCssValuesMap valuesMap = theme.getValuesMap();
        ConditionalValue[] values = valuesMap.getValues(cssElement, cssProperty);
        QxType result = selector.select(values, widget);
        if (result == null) {
            theme = ThemeUtil.getDefaultTheme();
            valuesMap = theme.getValuesMap();
            values = valuesMap.getValues(cssElement, cssProperty);
            result = selector.select(values, widget);
        }
        return result;
    }

    private ThemeUtil() {
    }
}

