/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme.css;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.css.IStylePropertyMap;

public class StylePropertyMap
implements IStylePropertyMap {
    private final Map properties = new HashMap();

    public void setProperty(String key, QxType value) {
        if (key == null || value == null) {
            throw new NullPointerException("null argument");
        }
        this.properties.put(key, value);
    }

    public String[] getProperties() {
        Set keySet = this.properties.keySet();
        String[] result = new String[keySet.size()];
        keySet.toArray(result);
        return result;
    }

    public QxType getValue(String propertyName) {
        return (QxType)this.properties.get(propertyName);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("{\n");
        String[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            String property = properties[i];
            QxType value = this.getValue(property);
            result.append("  ");
            result.append(property);
            result.append(": ");
            result.append(value);
            result.append(";\n");
            ++i;
        }
        result.append("}");
        return result.toString();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj == this) {
            result = true;
        } else if (obj.getClass() == this.getClass()) {
            StylePropertyMap other = (StylePropertyMap)obj;
            result = this.properties.equals(other.properties);
        }
        return result;
    }

    public int hashCode() {
        return this.properties.hashCode();
    }
}

