/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.graphics.GCAdapter;
import org.eclipse.swt.internal.graphics.GCOperation;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class GC
extends Resource {
    private final Control control;
    private Font font;
    private Color background;
    private Color foreground;
    private int alpha;
    private int lineWidth;
    private int lineCap;
    private int lineJoin;
    private int style;
    static /* synthetic */ Class class$0;

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        super(GC.determineDevice(drawable));
        if (drawable == null) {
            SWT.error(4);
        }
        this.control = drawable instanceof Control ? (Control)drawable : null;
        this.style = GC.checkStyle(style);
        this.font = GC.determineFont(drawable);
        this.background = GC.determineBackground(drawable);
        this.foreground = GC.determineForeground(drawable);
        this.alpha = 255;
        this.lineCap = 1;
        this.lineJoin = 1;
    }

    public void setFont(Font font) {
        Font newFont;
        this.checkDisposed();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        Font font2 = newFont = font != null ? font : this.getDevice().getSystemFont();
        if (!newFont.equals(this.font)) {
            this.font = newFont;
            GCOperation.SetFont operation = new GCOperation.SetFont(this.font);
            this.addGCOperation(operation);
        }
    }

    public Font getFont() {
        this.checkDisposed();
        return this.font;
    }

    public int getCharWidth(char ch) {
        this.checkDisposed();
        return Graphics.stringExtent((Font)this.font, (String)Character.toString((char)ch)).x;
    }

    public Point stringExtent(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.checkDisposed();
        return Graphics.stringExtent(this.font, string);
    }

    public Point textExtent(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.checkDisposed();
        return Graphics.textExtent(this.font, string, 0);
    }

    public FontMetrics getFontMetrics() {
        this.checkDisposed();
        return new FontMetrics(this.font);
    }

    public void setBackground(Color color) {
        this.checkDisposed();
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (!color.equals(this.background)) {
            this.background = color;
            GCOperation.SetProperty operation = new GCOperation.SetProperty(1, this.background);
            this.addGCOperation(operation);
        }
    }

    public Color getBackground() {
        this.checkDisposed();
        return this.background;
    }

    public void setForeground(Color color) {
        this.checkDisposed();
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (!color.equals(this.foreground)) {
            this.foreground = color;
            GCOperation.SetProperty operation = new GCOperation.SetProperty(0, this.foreground);
            this.addGCOperation(operation);
        }
    }

    public Color getForeground() {
        this.checkDisposed();
        return this.foreground;
    }

    public Rectangle getClipping() {
        this.checkDisposed();
        Rectangle result = this.control != null ? this.control.getBounds() : this.device.getBounds();
        return result;
    }

    public void setAlpha(int alpha) {
        this.checkDisposed();
        if (alpha >= 0 && alpha <= 255 && this.alpha != alpha) {
            this.alpha = alpha;
            GCOperation.SetProperty operation = new GCOperation.SetProperty(2, new Integer(alpha));
            this.addGCOperation(operation);
        }
    }

    public int getAlpha() {
        this.checkDisposed();
        return this.alpha;
    }

    public void setLineWidth(int lineWidth) {
        this.checkDisposed();
        if (this.lineWidth != lineWidth) {
            this.lineWidth = lineWidth;
            GCOperation.SetProperty operation = new GCOperation.SetProperty(3, new Integer(lineWidth));
            this.addGCOperation(operation);
        }
    }

    public int getLineWidth() {
        this.checkDisposed();
        return this.lineWidth;
    }

    public void setLineCap(int lineCap) {
        this.checkDisposed();
        if (this.lineCap != lineCap) {
            switch (lineCap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            this.lineCap = lineCap;
            GCOperation.SetProperty operation = new GCOperation.SetProperty(4, new Integer(lineCap));
            this.addGCOperation(operation);
        }
    }

    public int getLineCap() {
        this.checkDisposed();
        return this.lineCap;
    }

    public void setLineJoin(int lineJoin) {
        this.checkDisposed();
        if (this.lineJoin != lineJoin) {
            switch (lineJoin) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
            this.lineJoin = lineJoin;
            GCOperation.SetProperty operation = new GCOperation.SetProperty(5, new Integer(lineJoin));
            this.addGCOperation(operation);
        }
    }

    public int getLineJoin() {
        this.checkDisposed();
        return this.lineJoin;
    }

    public void setLineAttributes(LineAttributes attributes) {
        this.checkDisposed();
        if (attributes == null) {
            SWT.error(4);
        }
        this.setLineWidth((int)attributes.width);
        this.setLineCap(attributes.cap);
        this.setLineJoin(attributes.join);
    }

    public LineAttributes getLineAttributes() {
        this.checkDisposed();
        return new LineAttributes(this.lineWidth, this.lineCap, this.lineJoin);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.checkDisposed();
        GCOperation.DrawLine operation = new GCOperation.DrawLine(x1, y1, x2, y2);
        this.addGCOperation(operation);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        this.drawRectangle(x, y, width, height, 0, 0, false);
    }

    public void drawFocus(int x, int y, int width, int height) {
        this.drawRectangle(x, y, width, height);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        this.drawRectangle(x, y, width, height, 0, 0, true);
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        this.checkDisposed();
        if (width != 0 && height != 0) {
            if (this.background.equals(this.foreground)) {
                this.fillRectangle(x, y, width, height);
            } else {
                GCOperation.FillGradientRectangle operation = new GCOperation.FillGradientRectangle(x, y, width, height, vertical);
                this.addGCOperation(operation);
            }
        }
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawRectangle(x, y, width, height, arcWidth, arcHeight, false);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawRectangle(x, y, width, height, arcWidth, arcHeight, true);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.drawArc(x, y, width, height, 0, 360, false);
    }

    public void fillOval(int x, int y, int width, int height) {
        this.drawArc(x, y, width, height, 0, 360, true);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc(x, y, width, height, startAngle, arcAngle, false);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.drawArc(x, y, width, height, startAngle, arcAngle, true);
    }

    public void drawPolygon(int[] pointArray) {
        this.checkDisposed();
        GCOperation.DrawPolyline operation = new GCOperation.DrawPolyline(pointArray, true, false);
        this.addGCOperation(operation);
    }

    public void fillPolygon(int[] pointArray) {
        this.checkDisposed();
        GCOperation.DrawPolyline operation = new GCOperation.DrawPolyline(pointArray, true, true);
        this.addGCOperation(operation);
    }

    public void drawPolyline(int[] pointArray) {
        this.checkDisposed();
        GCOperation.DrawPolyline operation = new GCOperation.DrawPolyline(pointArray, false, false);
        this.addGCOperation(operation);
    }

    public void drawPoint(int x, int y) {
        this.checkDisposed();
        GCOperation.DrawPoint operation = new GCOperation.DrawPoint(x, y);
        this.addGCOperation(operation);
    }

    public void drawImage(Image image, int x, int y) {
        this.checkDisposed();
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        GCOperation.DrawImage operation = new GCOperation.DrawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
        this.addGCOperation(operation);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        this.checkDisposed();
        if (srcWidth != 0 && srcHeight != 0 && destWidth != 0 && destHeight != 0) {
            if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
                SWT.error(5);
            }
            if (image == null) {
                SWT.error(4);
            }
            if (image.isDisposed()) {
                SWT.error(5);
            }
            GCOperation.DrawImage operation = new GCOperation.DrawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
            this.addGCOperation(operation);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        int flags = isTransparent ? 1 : 0;
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        this.checkDisposed();
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() != 0) {
            GCOperation.DrawText operation = new GCOperation.DrawText(string, x, y, flags);
            this.addGCOperation(operation);
        }
    }

    public int getStyle() {
        this.checkDisposed();
        return this.style;
    }

    private void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean fill) {
        this.checkDisposed();
        Rectangle bounds = GC.checkBounds(x, y, width, height);
        if (bounds.width != 0 && bounds.height != 0 && arcAngle != 0) {
            GCOperation.DrawArc operation = new GCOperation.DrawArc(bounds.x, bounds.y, bounds.width, bounds.height, startAngle, arcAngle, fill);
            this.addGCOperation(operation);
        }
    }

    private void drawRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean fill) {
        this.checkDisposed();
        Rectangle bounds = GC.checkBounds(x, y, width, height);
        if (bounds.width != 0 && bounds.height != 0) {
            GCOperation.DrawRectangle operation = arcWidth == 0 || arcHeight == 0 ? new GCOperation.DrawRectangle(bounds.x, bounds.y, bounds.width, bounds.height, fill) : new GCOperation.DrawRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, Math.abs(arcWidth), Math.abs(arcHeight), fill);
            this.addGCOperation(operation);
        }
    }

    private static Rectangle checkBounds(int x, int y, int width, int height) {
        Rectangle result = new Rectangle(x, y, width, height);
        if (width < 0) {
            result.x = x + width;
            result.width = -width;
        }
        if (height < 0) {
            result.y = y + height;
            result.height = -height;
        }
        return result;
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    private static int checkStyle(int style) {
        return 0x2000000;
    }

    GCAdapter getGCAdapter() {
        GCAdapter result = null;
        if (this.control != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.internal.graphics.IGCAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            result = (GCAdapter)this.control.getAdapter(clazz);
        }
        return result;
    }

    private void addGCOperation(GCOperation operation) {
        GCAdapter adapter = this.getGCAdapter();
        if (adapter != null) {
            adapter.addGCOperation(operation);
        }
    }

    private static Device determineDevice(Drawable drawable) {
        Device result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getDisplay();
        } else if (drawable instanceof Device) {
            result = (Device)drawable;
        }
        return result;
    }

    private static Font determineFont(Drawable drawable) {
        Font result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getFont();
        } else if (drawable instanceof Display) {
            result = ((Display)drawable).getSystemFont();
        }
        return result;
    }

    private static Color determineBackground(Drawable drawable) {
        Color result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getBackground();
        } else if (drawable instanceof Display) {
            result = ((Display)drawable).getSystemColor(1);
        }
        return result;
    }

    private static Color determineForeground(Drawable drawable) {
        Color result = null;
        if (drawable instanceof Control) {
            result = ((Control)drawable).getForeground();
        } else if (drawable instanceof Display) {
            result = ((Display)drawable).getSystemColor(2);
        }
        return result;
    }
}

