/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public abstract class GCOperation {

    public static final class DrawArc
    extends GCOperation {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final int startAngle;
        public final int arcAngle;
        public final boolean fill;

        public DrawArc(int x, int y, int width, int height, int startAngle, int arcAngle, boolean fill) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
            this.fill = fill;
        }
    }

    public static final class DrawImage
    extends GCOperation {
        public final Image image;
        public final int srcX;
        public final int srcY;
        public final int srcWidth;
        public final int srcHeight;
        public final int destX;
        public final int destY;
        public final int destWidth;
        public final int destHeight;
        public final boolean simple;

        public DrawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
            this.image = image;
            this.srcX = srcX;
            this.srcY = srcY;
            this.srcWidth = srcWidth;
            this.srcHeight = srcHeight;
            this.destX = destX;
            this.destY = destY;
            this.destWidth = destWidth;
            this.destHeight = destHeight;
            this.simple = simple;
        }
    }

    public static final class DrawLine
    extends GCOperation {
        public final int x1;
        public final int y1;
        public final int x2;
        public final int y2;

        public DrawLine(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }
    }

    public static final class DrawPoint
    extends GCOperation {
        public final int x;
        public final int y;

        public DrawPoint(int x, int y) {
            this.x = x;
            this.y = y;
        }
    }

    public static final class DrawPolyline
    extends GCOperation {
        public final int[] points;
        public final boolean close;
        public final boolean fill;

        public DrawPolyline(int[] points, boolean close, boolean fill) {
            this.points = new int[points.length];
            System.arraycopy(points, 0, this.points, 0, points.length);
            this.close = close;
            this.fill = fill;
        }
    }

    public static class DrawRectangle
    extends GCOperation {
        public final int x;
        public final int y;
        public final int width;
        public final int height;
        public final boolean fill;

        public DrawRectangle(int x, int y, int width, int height, boolean fill) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.fill = fill;
        }
    }

    public static final class DrawRoundRectangle
    extends DrawRectangle {
        public final int arcWidth;
        public final int arcHeight;

        public DrawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight, boolean fill) {
            super(x, y, width, height, fill);
            this.arcWidth = arcWidth;
            this.arcHeight = arcHeight;
        }
    }

    public static final class DrawText
    extends GCOperation {
        public final String text;
        public final int x;
        public final int y;
        public final int flags;

        public DrawText(String text, int x, int y, int flags) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.flags = flags;
        }
    }

    public static final class FillGradientRectangle
    extends DrawRectangle {
        public final boolean vertical;

        public FillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
            super(x, y, width, height, true);
            this.vertical = vertical;
        }
    }

    public static final class SetFont
    extends GCOperation {
        public final Font font;

        public SetFont(Font font) {
            this.font = font;
        }
    }

    public static final class SetProperty
    extends GCOperation {
        public static final int FOREGROUND = 0;
        public static final int BACKGROUND = 1;
        public static final int ALPHA = 2;
        public static final int LINE_WIDTH = 3;
        public static final int LINE_CAP = 4;
        public static final int LINE_JOIN = 5;
        public final int id;
        public final Object value;

        public SetProperty(int id, Object value) {
            this.id = id;
            this.value = value;
        }
    }
}

