/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.graphics;

import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.util.EncodingUtil;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.graphics.IFontMetricsEstimation;
import org.eclipse.swt.internal.graphics.TextSizeProbeStore;

public final class TextSizeEstimation {
    private static final String FONT_METRICS_ESTIMATION;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.internal.graphics.TextSizeEstimation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FONT_METRICS_ESTIMATION = String.valueOf(clazz.getName()) + "#fontMetricsEstimation";
    }

    public static void setFontMetricsEstimation(IFontMetricsEstimation value) {
        ISessionStore sessionStore = RWT.getSessionStore();
        sessionStore.setAttribute(FONT_METRICS_ESTIMATION, value);
    }

    public static IFontMetricsEstimation getFontMetricsEstimation() {
        ISessionStore sessionStore = RWT.getSessionStore();
        Object attribute = sessionStore.getAttribute(FONT_METRICS_ESTIMATION);
        IFontMetricsEstimation result = (IFontMetricsEstimation)attribute;
        if (result == null) {
            result = new DefaultFontMetricsEstimation();
            TextSizeEstimation.setFontMetricsEstimation(result);
        }
        return result;
    }

    static Point stringExtent(Font font, String string) {
        int width = TextSizeEstimation.getLineWidth(string, font);
        int height = TextSizeEstimation.getCharHeight(font) + 2;
        return new Point(width, height);
    }

    static Point textExtent(Font font, String string, int wrapWidth) {
        int lineCount = 0;
        int maxWidth = 0;
        String[] lines = EncodingUtil.splitNewLines(string);
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            ++lineCount;
            int width = TextSizeEstimation.getLineWidth(line, font);
            if (wrapWidth > 0) {
                boolean done = false;
                while (!done) {
                    int index = TextSizeEstimation.getLongestMatch(line, wrapWidth, font);
                    if (index == 0 || index == line.length()) {
                        done = true;
                        continue;
                    }
                    String substr = line.substring(0, index);
                    width = TextSizeEstimation.getLineWidth(substr, font);
                    maxWidth = Math.max(maxWidth, width);
                    line = line.substring(index, line.length());
                    ++lineCount;
                }
            }
            maxWidth = Math.max(maxWidth, width);
            ++i;
        }
        int height = Math.round((float)TextSizeEstimation.getCharHeight(font) * 1.25f * (float)lineCount);
        return new Point(maxWidth, height);
    }

    static int getCharHeight(Font font) {
        return TextSizeEstimation.getFontMetricsEstimation().getCharHeight(font);
    }

    static float getAvgCharWidth(Font font) {
        return TextSizeEstimation.getFontMetricsEstimation().getAverageCharWidth(font);
    }

    private static int getLongestMatch(String string, int wrapWidth, Font font) {
        int result = 0;
        if (TextSizeEstimation.getLineWidth(string, font) < wrapWidth) {
            result = string.length();
        } else {
            String subStr = TextSizeEstimation.nextSubLine(string, 0);
            boolean done = false;
            while (!done && TextSizeEstimation.getLineWidth(subStr, font) <= wrapWidth) {
                result = subStr.length();
                if (subStr.length() == string.length()) {
                    done = true;
                    continue;
                }
                subStr = TextSizeEstimation.nextSubLine(string, subStr.length() + 1);
            }
        }
        return result;
    }

    private static String nextSubLine(String line, int startIndex) {
        String result = line;
        int index = line.indexOf(32, startIndex);
        if (index != -1) {
            result = line.substring(0, index);
        }
        return result;
    }

    private static int getLineWidth(String line, Font font) {
        return Math.round(TextSizeEstimation.getAvgCharWidth(font) * (float)line.length());
    }

    private static final class DefaultFontMetricsEstimation
    implements IFontMetricsEstimation {
        private DefaultFontMetricsEstimation() {
        }

        public float getAverageCharWidth(Font font) {
            float result;
            FontData fontData = font.getFontData()[0];
            TextSizeProbeStore probeStore = TextSizeProbeStore.getInstance();
            if (probeStore.containsProbeResult(fontData)) {
                result = probeStore.getProbeResult(fontData).getAvgCharWidth();
            } else {
                result = (float)fontData.getHeight() * 0.48f;
                if ((fontData.getStyle() & 1) != 0) {
                    result = (float)((double)result * 1.45);
                }
            }
            return result;
        }

        public int getCharHeight(Font font) {
            return font.getFontData()[0].getHeight();
        }
    }
}

