/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class Dialog {
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    int style;
    Shell parent;
    String title;

    public Dialog(Shell parent) {
        this(parent, 32768);
    }

    public Dialog(Shell parent, int style) {
        this.checkParent(parent);
        this.parent = parent;
        this.style = style;
        this.title = "";
    }

    public Shell getParent() {
        return this.parent;
    }

    public int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.title;
    }

    public void setText(String string) {
        if (string == null) {
            this.error(4);
        }
        this.title = string;
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    void checkParent(Shell parent) {
        if (parent == null) {
            this.error(4);
        }
        parent.checkWidget();
    }

    void error(int code) {
        SWT.error(code);
    }

    static int checkStyle(Shell parent, int style) {
        int result = style;
        int mask = 229376;
        if ((result & 0x10000000) != 0 && ((result &= 0xEFFFFFFF) & mask) == 0) {
            result |= parent == null ? 65536 : 32768;
        }
        if ((result & mask) == 0) {
            result |= 0x10000;
        }
        if ((result & 0x2000000) == 0 && parent != null && (parent.style & 0x2000000) != 0) {
            result |= 0x2000000;
        }
        return result;
    }

    static int convertHorizontalDLUsToPixels(Control control, int dlus) {
        Font dialogFont = control.getFont();
        float charWidth = Graphics.getAvgCharWidth(dialogFont);
        float width = charWidth * (float)dlus + 2.0f;
        return (int)(width / 4.0f);
    }
}

