/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.StringTokenizer;
import org.eclipse.rwt.graphics.Graphics;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    private static final int BUTTON_WIDTH = 61;
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    private static final int MAX_WIDTH = 640;
    private Shell shell;
    private String message;
    private int returnCode;

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(style));
        this.checkSubclass();
        this.message = "";
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public int open() {
        this.shell = new Shell(this.parent, 67616);
        this.shell.setText(this.getText());
        this.createControls(this.shell);
        Rectangle parentSize = this.parent.getBounds();
        Point prefSize = this.shell.computeSize(-1, -1);
        if (prefSize.x > 640) {
            prefSize.x = 640;
        }
        this.shell.setSize(prefSize);
        int locationX = (parentSize.width - prefSize.x) / 2 + parentSize.x;
        int locationY = (parentSize.height - prefSize.y) / 2 + parentSize.y;
        this.shell.setLocation(new Point(locationX, locationY));
        this.shell.pack();
        this.shell.open();
        Display display = this.parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.returnCode;
    }

    private void createControls(Composite parent) {
        Display display = parent.getDisplay();
        Image icon = null;
        parent.setLayout(new GridLayout(2, false));
        int systemImageID = -1;
        if ((this.style & 1) != 0) {
            systemImageID = 1;
        } else if ((this.style & 2) != 0) {
            systemImageID = 2;
        } else if ((this.style & 4) != 0) {
            systemImageID = 4;
        } else if ((this.style & 8) != 0) {
            systemImageID = 8;
        } else if ((this.style & 0x10) != 0) {
            systemImageID = 16;
        }
        if (systemImageID != -1) {
            icon = display.getSystemImage(systemImageID);
            this.createIcon(parent, icon);
        }
        this.createText(parent, icon);
        Composite buttonComp = new Composite(parent, 0);
        buttonComp.setLayout(new GridLayout(0, true));
        GridData buttonData = new GridData(0x1000000, 0x1000000, true, false);
        buttonData.horizontalSpan = 2;
        buttonComp.setLayoutData(buttonData);
        if ((this.style & 0x40) == 64) {
            this.createButton(buttonComp, SWT.getMessage("SWT_Yes"), 64);
        }
        if ((this.style & 0x80) == 128) {
            this.createButton(buttonComp, SWT.getMessage("SWT_No"), 128);
        }
        if ((this.style & 0x20) == 32) {
            this.createButton(buttonComp, SWT.getMessage("SWT_OK"), 32);
        }
        if ((this.style & 0x200) == 512) {
            this.createButton(buttonComp, SWT.getMessage("SWT_Abort"), 512);
        }
        if ((this.style & 0x400) == 1024) {
            this.createButton(buttonComp, SWT.getMessage("SWT_Retry"), 1024);
        }
        if ((this.style & 0x100) == 256) {
            this.createButton(buttonComp, SWT.getMessage("SWT_Cancel"), 256);
        }
        if ((this.style & 0x800) == 2048) {
            this.createButton(buttonComp, SWT.getMessage("SWT_Ignore"), 2048);
        }
        buttonComp.getChildren()[0].forceFocus();
    }

    private Button createButton(Composite parent, String text, final int returnCode) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button result = new Button(parent, 8);
        GridData data = new GridData(256);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = result.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        result.setLayoutData(data);
        result.setText(text);
        result.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MessageBox.this.returnCode = returnCode;
                MessageBox.this.shell.close();
            }
        });
        return result;
    }

    private void createIcon(Composite parent, Image icon) {
        Label iconLabel = new Label(parent, 0x1000000);
        GridData data = new GridData(0x1000000, 128, false, false);
        data.widthHint = icon.getBounds().width + 20;
        iconLabel.setLayoutData(data);
        iconLabel.setImage(icon);
    }

    private void createText(Composite parent, Image icon) {
        Label textLabel = new Label(parent, 64);
        String message = this.getMessage();
        Font font = textLabel.getFont();
        GridData data = new GridData(256);
        int iconWidth = icon == null ? 0 : icon.getBounds().width;
        int maxTextWidth = 640 - iconWidth - 20;
        int maxLineWidth = 0;
        StringTokenizer st = new StringTokenizer(message, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            int lineWidth = Graphics.stringExtent((Font)font, (String)line).x;
            maxLineWidth = Math.max(maxLineWidth, lineWidth);
        }
        if (maxLineWidth > maxTextWidth) {
            data.widthHint = maxTextWidth;
        }
        textLabel.setLayoutData(data);
        textLabel.setText(message);
    }

    private int convertHorizontalDLUsToPixels(int dlus) {
        Font dialogFont = this.shell.getFont();
        float charWidth = Graphics.getAvgCharWidth(dialogFont);
        float width = charWidth * (float)dlus + 2.0f;
        return (int)(width / 4.0f);
    }

    private static int checkStyle(int style) {
        int chkStyle = 0;
        int mask = 4064;
        int bits = style & mask;
        chkStyle = bits == 32 || bits == 288 ? style : (bits == 192 || bits == 448 ? style : (bits == 1280 || bits == 3584 ? style : style & ~mask | 0x20));
        return chkStyle;
    }
}

