/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.rap.ui.internal.intro.IntroPlugin;
import org.eclipse.swt.widgets.Display;

public final class ErrorUtil {
    public static void show(String message, Throwable throwable) {
        final IStatus status = ErrorUtil.createErrorStatus(message, throwable);
        IntroPlugin.getDefault().getLog().log(status);
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, null, null, (IStatus)status);
            }
        });
    }

    public static void log(String message, Throwable throwable) {
        IStatus status = ErrorUtil.createErrorStatus(message, throwable);
        IntroPlugin.getDefault().getLog().log(status);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        IStatus result;
        Throwable cause = throwable;
        if (cause instanceof InvocationTargetException) {
            cause = ((InvocationTargetException)cause).getTargetException();
        }
        if (throwable instanceof CoreException) {
            result = ((CoreException)throwable).getStatus();
        } else {
            String statusMessage = message;
            if (statusMessage == null && throwable != null) {
                statusMessage = throwable.getMessage() != null ? throwable.getMessage() : throwable.toString();
            }
            if (statusMessage == null) {
                statusMessage = "";
            }
            result = new Status(4, IntroPlugin.getPluginId(), 0, statusMessage, throwable);
        }
        return result;
    }

    private ErrorUtil() {
    }
}

