/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.rap.ui.internal.intro.target.InstallTargetDialog;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.rap.ui.internal.intro.target.TargetProvider;
import org.eclipse.rap.ui.internal.intro.target.TargetSwitcher;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class InstallRAPTargetHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell shell = workbench.getActiveWorkbenchWindow().getShell();
        InstallTargetDialog dialog = new InstallTargetDialog(shell);
        int result = dialog.open();
        if (result == 0) {
            InstallRAPTargetHandler.execute(dialog.getTargetDestination(), dialog.shouldSwitchTarget());
        }
        return null;
    }

    public static void execute(final String targetDestination, final boolean switchTarget) throws ExecutionException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    TargetProvider.install(targetDestination, monitor);
                    if (switchTarget) {
                        TargetSwitcher.switchTarget(targetDestination, monitor);
                    }
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            String msg = IntroMessages.InstallRAPTargetHandler_InstallFailed;
            throw new ExecutionException(msg, cause);
        }
        catch (InterruptedException interruptedException) {
            String msg = IntroMessages.InstallRAPTargetHandler_InstallInterrupted;
            throw new ExecutionException(msg);
        }
    }
}

