/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.pde.internal.core.target.provisional.LoadTargetDefinitionJob;
import org.eclipse.rap.ui.internal.intro.ErrorUtil;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.rap.ui.internal.intro.target.TargetProvider;

public final class TargetSwitcher {
    private static final String TARGET_NAME_PATTERN = "Rich Ajax Platform {0}";
    private static final String VM_ARGS = "-Dosgi.noShutdown=true -Declipse.ignoreApp=true";
    private static final String PROGRAM_ARGS = "-console -consolelog";
    private static final String ECLIPSE = "eclipse";
    static /* synthetic */ Class class$0;

    public static void switchTarget(String targetDestination, IProgressMonitor monitor) throws CoreException {
        try {
            ITargetDefinition target = TargetSwitcher.createTargetDefinition(targetDestination);
            LoadTargetDefinitionJob job = new LoadTargetDefinitionJob(target);
            job.setUser(true);
            job.schedule();
            job.join();
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (InterruptedException e) {
            String msg = IntroMessages.InstallRAPTargetHandler_SwitchTargetInterrupted;
            ErrorUtil.log(msg, e);
        }
    }

    private static ITargetDefinition createTargetDefinition(String dest) throws CoreException {
        ITargetPlatformService service = TargetSwitcher.getTargetPlatformService();
        ITargetDefinition target = service.newTarget();
        target.setName(TargetSwitcher.getTargetName());
        target.setProgramArguments(PROGRAM_ARGS);
        target.setVMArguments(VM_ARGS);
        String eclipse = TargetSwitcher.appendPath(dest, ECLIPSE);
        IBundleContainer bundleContainer = service.newDirectoryContainer(eclipse);
        target.setBundleContainers(new IBundleContainer[]{bundleContainer});
        service.saveTargetDefinition(target);
        return target;
    }

    private static ITargetPlatformService getTargetPlatformService() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String className = clazz.getName();
        PDECore pdeCore = PDECore.getDefault();
        return (ITargetPlatformService)pdeCore.acquireService(className);
    }

    private static String getTargetName() {
        Object[] args = new String[]{TargetProvider.getRAPRuntimeVersion()};
        return MessageFormat.format(TARGET_NAME_PATTERN, args);
    }

    private static String appendPath(String path, String append) {
        File filePath = new File(path);
        File result = new File(filePath, append);
        return result.toString();
    }

    private TargetSwitcher() {
    }
}

