/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.junit;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.junit.launcher.JUnitLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.ui.launcher.EquinoxLaunchConfiguration;
import org.eclipse.rap.ui.internal.launch.LaunchMessages;
import org.eclipse.rap.ui.internal.launch.RAPLaunchDelegate;

public class RAPJUnitLaunchConfigurationDelegate
extends JUnitLaunchConfigurationDelegate {
    private JUnitLaunchConfigurationDelegate julc = new org.eclipse.pde.ui.launcher.JUnitLaunchConfigurationDelegate();
    private EquinoxLaunchConfigurationExtension elc = new EquinoxLaunchConfigurationExtension();
    private RAPLaunchDelegate rld = new RAPLaunchDelegate(true);

    public boolean finalLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        this.rld.finalLaunchCheck(configuration, mode, monitor);
        return super.finalLaunchCheck(configuration, mode, monitor);
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = this.rld.doPreLaunch(configuration, launch, monitor);
        super.launch(configuration, mode, launch, (IProgressMonitor)subMonitor);
    }

    protected void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        super.preLaunchCheck(configuration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        this.elc.preLaunchCheck(configuration, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
    }

    public IVMRunner getVMRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.julc.getVMRunner(configuration, mode);
    }

    public String verifyMainTypeName(ILaunchConfiguration configuration) throws CoreException {
        return "org.eclipse.equinox.launcher.Main";
    }

    public String[] getClasspath(ILaunchConfiguration configuration) throws CoreException {
        return this.julc.getClasspath(configuration);
    }

    public String getProgramArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] programArguments = this.elc.getProgramArguments(configuration);
        return this.concatArguments(programArguments);
    }

    private String concatArguments(String[] arguments) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < arguments.length) {
            result.append(arguments[i]);
            result.append(" ");
            ++i;
        }
        return result.toString().trim();
    }

    public String getVMArguments(ILaunchConfiguration configuration) throws CoreException {
        String[] arguments = this.rld.getVMArguments(configuration);
        return this.concatArguments(arguments);
    }

    protected void collectExecutionArguments(ILaunchConfiguration config, List vmArguments, List programArguments) throws CoreException {
        super.collectExecutionArguments(config, vmArguments, programArguments);
        String name = "-loaderpluginname";
        String value = "org.eclipse.rap.junit.runtime";
        this.replaceArguments(programArguments, name, value);
        programArguments.add("-testpluginname");
        programArguments.add(this.getTestPluginId(config));
    }

    private void replaceArguments(List list, String name, String value) {
        int pos = list.indexOf(name);
        list.remove(pos + 1);
        list.add(pos + 1, value);
    }

    private String getTestPluginId(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        IProject project = javaProject.getProject();
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model == null) {
            String msg = NLS.bind((String)LaunchMessages.RAPLaunchDelegate_Error_NotAPlugin, (Object)project.getName());
            this.abort(msg, null, 0);
        }
        if (model instanceof IFragmentModel) {
            return ((IFragmentModel)model).getFragment().getPluginId();
        }
        return model.getPluginBase().getId();
    }

    private final class EquinoxLaunchConfigurationExtension
    extends EquinoxLaunchConfiguration {
        private EquinoxLaunchConfigurationExtension() {
        }

        public void preLaunchCheck(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
            super.preLaunchCheck(configuration, launch, monitor);
        }
    }
}

