/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.tab;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.rap.ui.internal.launch.LaunchMessages;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfig;
import org.eclipse.rap.ui.internal.launch.RAPLaunchConfigValidator;
import org.eclipse.rap.ui.internal.launch.tab.BrandingExtension;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointExtension;
import org.eclipse.rap.ui.internal.launch.tab.EntryPointSelectionDialog;
import org.eclipse.rap.ui.internal.launch.tab.ServletNameSelectionDialog;
import org.eclipse.rap.ui.internal.launch.util.ErrorUtil;
import org.eclipse.rap.ui.internal.launch.util.Images;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class MainTab
extends AbstractLaunchConfigurationTab {
    private static final String BROWSER_PREFERENCE_PAGE = "org.eclipse.ui.browser.preferencePage";
    private final GridDataFactory fillHorizontal;
    private final ModifyListener modifyListener;
    private final SelectionListener selectionListener;
    private final Image tabImage = Images.DESC_MAIN_TAB.createImage();
    private final Image warnImage = Images.WARNING.createImage();
    private Text txtServletName;
    private Text txtEntryPoint;
    private Button cbTerminatePrevious;
    private Button cbOpenBrowser;
    private Button rbInternalBrowser;
    private Button rbExternalBrowser;
    private Button cbManualPort;
    private Spinner spnPort;
    private Button cbUseSessionTimeout;
    private Spinner spnSessionTimeout;
    private ComboViewer cmbLogLevel;
    private ComboViewer cmbLibVariant;

    public MainTab() {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.fillHorizontal = GridDataFactory.createFrom((GridData)gridData);
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        };
    }

    public void dispose() {
        this.tabImage.dispose();
        this.warnImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.createServletNameAndEntryPointSection(container);
        this.createBrowserModeSection(container);
        this.createRuntimeSettingsSection(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    public String getName() {
        return LaunchMessages.MainTab_Name;
    }

    public Image getImage() {
        return this.tabImage;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        RAPLaunchConfig rapConfig = new RAPLaunchConfig(config);
        try {
            this.txtServletName.setText(rapConfig.getServletName());
            this.txtEntryPoint.setText(rapConfig.getEntryPoint());
            this.cbTerminatePrevious.setSelection(rapConfig.getTerminatePrevious());
            this.cbManualPort.setSelection(rapConfig.getUseManualPort());
            this.spnPort.setSelection(rapConfig.getPort());
            boolean openBrowser = rapConfig.getOpenBrowser();
            this.cbOpenBrowser.setSelection(openBrowser);
            this.rbInternalBrowser.setEnabled(openBrowser);
            this.rbExternalBrowser.setEnabled(openBrowser);
            if (RAPLaunchConfig.BrowserMode.EXTERNAL.equals(rapConfig.getBrowserMode())) {
                this.rbExternalBrowser.setSelection(true);
                this.rbInternalBrowser.setSelection(false);
            } else {
                this.rbExternalBrowser.setSelection(false);
                this.rbInternalBrowser.setSelection(true);
            }
            this.cbUseSessionTimeout.setSelection(rapConfig.getUseSessionTimeout());
            this.spnSessionTimeout.setSelection(rapConfig.getSessionTimeout());
            Level logLevel = rapConfig.getLogLevel();
            StructuredSelection logSelection = new StructuredSelection((Object)logLevel);
            this.cmbLogLevel.setSelection((ISelection)logSelection);
            RAPLaunchConfig.LibraryVariant libVariant = rapConfig.getLibraryVariant();
            StructuredSelection libSelection = new StructuredSelection((Object)libVariant);
            this.cmbLibVariant.setSelection((ISelection)libSelection);
        }
        catch (CoreException e) {
            ErrorUtil.show(null, e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig rapConfig = new RAPLaunchConfig((ILaunchConfiguration)config);
        rapConfig.setServletName(this.txtServletName.getText());
        rapConfig.setEntryPoint(this.txtEntryPoint.getText());
        rapConfig.setTerminatePrevious(this.cbTerminatePrevious.getSelection());
        rapConfig.setOpenBrowser(this.cbOpenBrowser.getSelection());
        rapConfig.setBrowserMode(this.getBrowserMode());
        this.spnPort.setEnabled(this.cbManualPort.getSelection());
        rapConfig.setUseManualPort(this.cbManualPort.getSelection());
        rapConfig.setPort(this.spnPort.getSelection());
        this.spnSessionTimeout.setEnabled(this.cbUseSessionTimeout.getSelection());
        rapConfig.setUseSessionTimeout(this.cbUseSessionTimeout.getSelection());
        rapConfig.setSessionTimeout(this.spnSessionTimeout.getSelection());
        rapConfig.setLogLevel(this.getLogLevel());
        rapConfig.setLibraryVariant(this.getLibraryVariant());
        this.validate(rapConfig);
        this.setDirty(true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig.setDefaults(config);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    private void createServletNameAndEntryPointSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_ServletAndEntryPoint);
        Label lblServletName = new Label((Composite)group, 0);
        lblServletName.setText(LaunchMessages.MainTab_ServletName);
        this.txtServletName = new Text((Composite)group, 2048);
        this.txtServletName.setLayoutData((Object)this.fillHorizontal.create());
        this.txtServletName.addModifyListener(this.modifyListener);
        Button btnBrowseServletName = new Button((Composite)group, 8);
        btnBrowseServletName.setText(LaunchMessages.MainTab_BrowseServletName);
        btnBrowseServletName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowseServletName();
            }
        });
        Label lblEntryPoint = new Label((Composite)group, 0);
        lblEntryPoint.setText(LaunchMessages.MainTab_EntryPoint);
        this.txtEntryPoint = new Text((Composite)group, 2048);
        this.txtEntryPoint.setLayoutData((Object)this.fillHorizontal.create());
        this.txtEntryPoint.addModifyListener(this.modifyListener);
        Button btnBrowseEntryPoint = new Button((Composite)group, 8);
        btnBrowseEntryPoint.setText(LaunchMessages.MainTab_BrowseEntryPoint);
        btnBrowseEntryPoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowseEntryPoint();
            }
        });
        this.cbTerminatePrevious = new Button((Composite)group, 32);
        this.cbTerminatePrevious.setLayoutData((Object)MainTab.spanHorizontal(3, 0));
        String text = LaunchMessages.MainTab_TerminatePrevious;
        this.cbTerminatePrevious.setText(text);
        this.cbTerminatePrevious.addSelectionListener(this.selectionListener);
    }

    private void createBrowserModeSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_Browser);
        group.setLayout((Layout)new GridLayout(2, false));
        this.cbOpenBrowser = new Button((Composite)group, 32);
        GridDataFactory grab = GridDataFactory.swtDefaults();
        grab.grab(true, false);
        this.cbOpenBrowser.setLayoutData((Object)grab.create());
        this.cbOpenBrowser.setText(LaunchMessages.MainTab_OpenApplicationIn);
        this.cbOpenBrowser.addSelectionListener(this.selectionListener);
        Link lnkBrowserPrefs = new Link((Composite)group, 0);
        lnkBrowserPrefs.setText(LaunchMessages.MainTab_ConfigureBrowsers);
        lnkBrowserPrefs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MainTab.this.handleBrowserPrefsLink();
            }
        });
        this.rbInternalBrowser = new Button((Composite)group, 16);
        this.rbInternalBrowser.setLayoutData((Object)MainTab.spanHorizontal(2, 17));
        this.rbInternalBrowser.setText(LaunchMessages.MainTab_InternalBrowser);
        this.rbInternalBrowser.addSelectionListener(this.selectionListener);
        this.rbExternalBrowser = new Button((Composite)group, 16);
        this.rbExternalBrowser.setLayoutData((Object)MainTab.spanHorizontal(2, 17));
        this.rbExternalBrowser.setText(LaunchMessages.MainTab_ExternalBrowser);
        this.rbExternalBrowser.addSelectionListener(this.selectionListener);
        this.cbOpenBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean openBrowser = MainTab.this.cbOpenBrowser.getSelection();
                MainTab.this.rbInternalBrowser.setEnabled(openBrowser);
                MainTab.this.rbExternalBrowser.setEnabled(openBrowser);
            }
        });
    }

    private void createRuntimeSettingsSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText(LaunchMessages.MainTab_RuntimeSettings);
        group.setLayout((Layout)new GridLayout(2, false));
        this.cbManualPort = new Button((Composite)group, 32);
        this.cbManualPort.setText(LaunchMessages.MainTab_ManualPortConfig);
        this.cbManualPort.addSelectionListener(this.selectionListener);
        this.spnPort = new Spinner((Composite)group, 2048);
        this.spnPort.setLayoutData((Object)new GridData(60, -1));
        this.spnPort.setMinimum(0);
        this.spnPort.setMaximum(65535);
        this.spnPort.addModifyListener(this.modifyListener);
        this.cbUseSessionTimeout = new Button((Composite)group, 32);
        this.cbUseSessionTimeout.setText(LaunchMessages.MainTab_ManualTimeoutConfig);
        this.cbUseSessionTimeout.addSelectionListener(this.selectionListener);
        this.spnSessionTimeout = new Spinner((Composite)group, 2048);
        this.spnSessionTimeout.setLayoutData((Object)new GridData(60, -1));
        this.spnSessionTimeout.setMinimum(0);
        this.spnSessionTimeout.setMaximum(Integer.MAX_VALUE);
        this.spnSessionTimeout.addModifyListener(this.modifyListener);
        Label lblLogLevel = new Label((Composite)group, 0);
        lblLogLevel.setText(LaunchMessages.MainTab_ClientLogLevel);
        this.cmbLogLevel = new ComboViewer((Composite)group, 12);
        int itemCount = RAPLaunchConfig.LOG_LEVELS.length;
        this.cmbLogLevel.getCombo().setVisibleItemCount(itemCount);
        this.cmbLogLevel.setLabelProvider((IBaseLabelProvider)new LogLevelLabelProvider());
        this.cmbLogLevel.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmbLogLevel.setInput((Object)RAPLaunchConfig.LOG_LEVELS);
        this.cmbLogLevel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
        Label lblLibraryVariant = new Label((Composite)group, 0);
        lblLibraryVariant.setText(LaunchMessages.MainTab_ClientLibraryVariant);
        this.cmbLibVariant = new ComboViewer((Composite)group, 12);
        this.cmbLibVariant.setLabelProvider((IBaseLabelProvider)new LibraryVariantLabelProvider());
        this.cmbLibVariant.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.cmbLibVariant.setInput((Object)RAPLaunchConfig.LibraryVariant.values());
        this.cmbLibVariant.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private static GridData spanHorizontal(int span, int indent) {
        GridData result = new GridData(4, 0x1000000, true, false, span, -1);
        result.horizontalIndent = indent;
        return result;
    }

    private void validate(RAPLaunchConfig config) {
        RAPLaunchConfigValidator validator = new RAPLaunchConfigValidator(config);
        IStatus[] states = validator.validate();
        String infoMessage = MainTab.findMessage(states, 1);
        String warnMessage = MainTab.findMessage(states, 2);
        String errorMessage = MainTab.findMessage(states, 4);
        if (warnMessage != null) {
            this.setMessage(warnMessage);
        } else {
            this.setMessage(infoMessage);
        }
        this.setErrorMessage(errorMessage);
    }

    private static String findMessage(IStatus[] states, int severity) {
        String result = null;
        int i = 0;
        while (result == null && i < states.length) {
            if (states[i].matches(severity)) {
                result = states[i].getMessage();
            }
            ++i;
        }
        return result;
    }

    private void handleBrowseEntryPoint() {
        EntryPointSelectionDialog dialog = new EntryPointSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            EntryPointExtension entryPoint = (EntryPointExtension)selection[0];
            this.txtEntryPoint.setText(entryPoint.getParameter());
        }
    }

    private void handleBrowseServletName() {
        ServletNameSelectionDialog dialog = new ServletNameSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            Object[] selection = dialog.getResult();
            BrandingExtension branding = (BrandingExtension)selection[0];
            this.txtServletName.setText(branding.getServletName());
            String defaultEntryPointId = branding.getDefaultEntryPointId();
            String parameter = null;
            EntryPointExtension defaultEntryPoint = EntryPointExtension.findById(defaultEntryPointId);
            if (defaultEntryPoint != null) {
                parameter = defaultEntryPoint.getParameter();
            }
            if (this.txtEntryPoint.getText().length() == 0 && parameter != null) {
                this.txtEntryPoint.setText(parameter);
            }
        }
    }

    private void handleBrowserPrefsLink() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)BROWSER_PREFERENCE_PAGE, null, null);
        dialog.open();
        dialog.close();
    }

    private RAPLaunchConfig.BrowserMode getBrowserMode() {
        return this.rbExternalBrowser.getSelection() ? RAPLaunchConfig.BrowserMode.EXTERNAL : RAPLaunchConfig.BrowserMode.INTERNAL;
    }

    private Level getLogLevel() {
        Level result = Level.OFF;
        ISelection selection = this.cmbLogLevel.getSelection();
        if (!selection.isEmpty()) {
            result = (Level)((IStructuredSelection)selection).getFirstElement();
        }
        return result;
    }

    private RAPLaunchConfig.LibraryVariant getLibraryVariant() {
        RAPLaunchConfig.LibraryVariant result = RAPLaunchConfig.LibraryVariant.STANDARD;
        ISelection selection = this.cmbLibVariant.getSelection();
        if (!selection.isEmpty()) {
            IStructuredSelection structuredSel = (IStructuredSelection)selection;
            result = (RAPLaunchConfig.LibraryVariant)structuredSel.getFirstElement();
        }
        return result;
    }

    private static final class LibraryVariantLabelProvider
    extends LabelProvider {
        private LibraryVariantLabelProvider() {
        }

        public String getText(Object element) {
            String result = RAPLaunchConfig.LibraryVariant.STANDARD.equals(element) ? LaunchMessages.MainTab_LibraryVariantStandard : (RAPLaunchConfig.LibraryVariant.DEBUG.equals(element) ? LaunchMessages.MainTab_LibraryVariantDebug : super.getText(element));
            return result;
        }
    }

    private static final class LogLevelLabelProvider
    extends LabelProvider {
        private static final Map lables = new HashMap();

        static {
            lables.put(Level.ALL, LaunchMessages.MainTab_LogLevelAll);
            lables.put(Level.OFF, LaunchMessages.MainTab_LogLevelOff);
            lables.put(Level.CONFIG, LaunchMessages.MainTab_LogLevelConfig);
            lables.put(Level.WARNING, LaunchMessages.MainTab_LogLevelWarning);
            lables.put(Level.SEVERE, LaunchMessages.MainTab_LogLevelSevere);
            lables.put(Level.FINE, LaunchMessages.MainTab_LogLevelFine);
            lables.put(Level.FINER, LaunchMessages.MainTab_LogLevelFiner);
            lables.put(Level.FINEST, LaunchMessages.MainTab_LogLevelFinest);
            lables.put(Level.INFO, LaunchMessages.MainTab_LogLevelInfo);
        }

        private LogLevelLabelProvider() {
        }

        public String getText(Object element) {
            String result = (String)lables.get(element);
            if (result == null) {
                result = super.getText(element);
            }
            return result;
        }
    }
}

