/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.application;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.rap.ui.internal.servlet.EntryPointExtension;
import org.eclipse.rwt.internal.lifecycle.EntryPointManager;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.osgi.framework.Bundle;

public final class ApplicationRegistry {
    private static final String RUN = "run";
    private static final String PI_RUNTIME = "org.eclipse.core.runtime";
    private static final String PT_APPLICATIONS = "applications";
    private static final String PT_APP_VISIBLE = "visible";
    private static Map appEntrypointMapping = new HashMap();
    static /* synthetic */ Class class$0;

    public static IApplication getApplication() {
        IApplication application = null;
        String currentEntryPoint = EntryPointManager.getCurrentEntryPoint();
        Class clazz = (Class)appEntrypointMapping.get(currentEntryPoint);
        try {
            application = (IApplication)clazz.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return application;
    }

    private static void registerApplication(IExtension extension) {
        block5: {
            IConfigurationElement configElement = extension.getConfigurationElements()[0];
            String contributorName = configElement.getContributor().getName();
            IConfigurationElement[] runElement = configElement.getChildren(RUN);
            String className = runElement[0].getAttribute("class");
            String applicationId = extension.getUniqueIdentifier();
            String applicationParameter = extension.getSimpleIdentifier();
            String isVisible = configElement.getAttribute(PT_APP_VISIBLE);
            try {
                if (isVisible != null && !Boolean.valueOf(isVisible).booleanValue()) break block5;
                Bundle bundle = Platform.getBundle((String)contributorName);
                Class clazz = bundle.loadClass(className);
                appEntrypointMapping.put(applicationParameter, clazz);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.rap.ui.internal.application.EntrypointApplicationWrapper");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                EntryPointManager.register((String)applicationParameter, (Class)clazz2);
                EntryPointExtension.bind(applicationId, applicationParameter);
            }
            catch (ClassNotFoundException e) {
                String text = "Could not register application ''{0}'' with request startup parameter ''{1}''.";
                Object[] params = new Object[]{className, applicationParameter};
                String msg = MessageFormat.format(text, params);
                Status status = new Status(4, contributorName, 0, msg, (Throwable)e);
                WorkbenchPlugin.getDefault().getLog().log((IStatus)status);
            }
        }
    }

    public static void registerApplicationEntryPoints() {
        IExtension[] elements = ApplicationRegistry.getApplicationExtensions();
        int i = 0;
        while (i < elements.length) {
            ApplicationRegistry.registerApplication(elements[i]);
            ++i;
        }
    }

    private static IExtension[] getApplicationExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        String extensionPointId = "org.eclipse.core.runtime.applications";
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        return extensionPoint.getExtensions();
    }

    private ApplicationRegistry() {
    }
}

