/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.services.SourcePriorityNameMapping;
import org.eclipse.ui.services.AbstractServiceFactory;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.statushandlers.StatusManager;

public class WorkbenchServiceRegistry {
    private static final String WORKBENCH_LEVEL = "workbench";
    private static final String EXT_ID_SERVICES = "org.eclipse.ui.services";
    private static WorkbenchServiceRegistry registry = null;
    public static final IServiceLocator GLOBAL_PARENT = new IServiceLocator(){

        public Object getService(Class api) {
            return null;
        }

        public boolean hasService(Class api) {
            return false;
        }
    };
    private Map factories = new HashMap();
    private static final String[] supportedLevels = new String[]{"activeContexts", "activeShell", "activeWorkbenchWindow", "activeEditorId", "activePartId", "activeSite"};

    public static WorkbenchServiceRegistry getRegistry() {
        if (registry == null) {
            registry = new WorkbenchServiceRegistry();
        }
        return registry;
    }

    public Object getService(Class key, IServiceLocator parentLocator, IServiceLocator locator) {
        Object f = this.factories.get(key.getName());
        if (f instanceof AbstractServiceFactory) {
            AbstractServiceFactory factory = (AbstractServiceFactory)f;
            return factory.create(key, parentLocator, locator);
        }
        return this.loadFromRegistry(key, parentLocator, locator);
    }

    private Object loadFromRegistry(Class key, IServiceLocator parentLocator, IServiceLocator locator) {
        Object service = null;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(EXT_ID_SERVICES);
        IConfigurationElement[] serviceFactories = ep.getConfigurationElements();
        try {
            String requestedName = key.getName();
            boolean done = false;
            int i = 0;
            while (i < serviceFactories.length && !done) {
                IConfigurationElement[] serviceNames = serviceFactories[i].getChildren("service");
                int j = 0;
                while (j < serviceNames.length && !done) {
                    String serviceName = serviceNames[j].getAttribute("serviceClass");
                    if (requestedName.equals(serviceName)) {
                        done = true;
                    }
                    ++j;
                }
                if (done) {
                    AbstractServiceFactory f = (AbstractServiceFactory)serviceFactories[i].createExecutableExtension("factoryClass");
                    int j2 = 0;
                    while (j2 < serviceNames.length) {
                        String serviceName = serviceNames[j2].getAttribute("serviceClass");
                        if (this.factories.containsKey(serviceName)) {
                            WorkbenchPlugin.log("Factory already exists for " + serviceName);
                        } else {
                            this.factories.put(serviceName, f);
                        }
                        ++j2;
                    }
                    service = f.create(key, parentLocator, locator);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
        return service;
    }

    public AbstractSourceProvider[] getSourceProviders() {
        ArrayList<Object> providers = new ArrayList<Object>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(EXT_ID_SERVICES);
        IConfigurationElement[] elements = ep.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            if (elements[i].getName().equals("sourceProvider")) {
                try {
                    Object sourceProvider = elements[i].createExecutableExtension("provider");
                    if (!(sourceProvider instanceof AbstractSourceProvider)) {
                        String attributeName = elements[i].getAttribute("provider");
                        String message = "Source Provider '" + attributeName + "' should extend AbstractSourceProvider";
                        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, message);
                        WorkbenchPlugin.log((IStatus)status);
                    } else {
                        providers.add(sourceProvider);
                        this.processVariables(elements[i].getChildren("variable"));
                    }
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e.getStatus());
                }
            }
            ++i;
        }
        return providers.toArray(new AbstractSourceProvider[providers.size()]);
    }

    private void processVariables(IConfigurationElement[] children) {
        int i = 0;
        while (i < children.length) {
            String name = children[i].getAttribute("name");
            if (name != null && name.length() != 0) {
                String level = children[i].getAttribute("priorityLevel");
                if (level == null || level.length() == 0) {
                    level = WORKBENCH_LEVEL;
                } else {
                    boolean found = false;
                    int j = 0;
                    while (j < supportedLevels.length && !found) {
                        if (supportedLevels[j].equals(level)) {
                            found = true;
                        }
                        ++j;
                    }
                    if (!found) {
                        level = WORKBENCH_LEVEL;
                    }
                }
                int existingPriority = SourcePriorityNameMapping.getMapping(level);
                int newPriority = existingPriority << 1;
                SourcePriorityNameMapping.addMapping(name, newPriority);
            }
            ++i;
        }
    }
}

