/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.beans.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.beans.common.AbstractBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordNode
extends AbstractBean {
    private final WordNode parent;
    private String word;
    private boolean isUpperCase;
    private List<WordNode> children;

    public WordNode(String word) {
        this(null, word);
    }

    public WordNode(WordNode parent, String word) {
        Assert.isNotNull((Object)word);
        this.parent = parent;
        this.word = word;
        this.children = new ArrayList<WordNode>();
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public int getACount() {
        int result = 0;
        char[] cArray = this.word.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == 'a' || c == 'A') {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public float getAQuota() {
        return (float)this.getACount() / (float)this.word.length() * 100.0f;
    }

    public List<WordNode> getChildren() {
        return new ArrayList<WordNode>(this.children);
    }

    public WordNode getParent() {
        return this.parent;
    }

    public String getWord() {
        return this.isUpperCase ? this.word.toUpperCase() : this.word;
    }

    public String getWordIgnoreUppercase() {
        return this.word;
    }

    public boolean isUpperCase() {
        return this.isUpperCase;
    }

    public void setChildren(List<WordNode> children) {
        List<WordNode> oldChildren = this.children;
        this.children = new ArrayList<WordNode>(children);
        this.firePropertyChanged("children", oldChildren, this.children);
    }

    public void setUpperCase(boolean isUppercase) {
        boolean oldValue = this.isUpperCase;
        this.isUpperCase = isUppercase;
        this.firePropertyChanged("upperCase", oldValue, this.isUpperCase);
    }

    public void setWord(String word) {
        String oldWord = word;
        this.word = word;
        this.firePropertyChanged("word", oldWord, this.word);
    }

    public String toString() {
        return this.word;
    }

    private void addChild(WordNode child) {
        Assert.isNotNull((Object)child);
        List<WordNode> newChildren = this.getChildren();
        newChildren.add(child);
        this.setChildren(newChildren);
    }
}

