/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.communication.core.attachment;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.communication.core.attachment.AttachmentSerialized;
import org.eclipse.riena.communication.core.attachment.ByteArrayDataSource;
import org.eclipse.riena.communication.core.attachment.FileDataSource;
import org.eclipse.riena.communication.core.attachment.HttpURLDataSource;
import org.eclipse.riena.communication.core.attachment.IDataSource;
import org.eclipse.riena.communication.core.attachment.InputStreamDataSource;
import org.eclipse.riena.core.util.Nop;

public class Attachment {
    private static final int READ_BLOCK_SIZE = 10000;
    private transient Type type;
    private transient File file;
    private transient IDataSource dataSource;
    private ByteArrayDataSource internalDataSource = null;

    private Attachment() {
    }

    public Attachment(File file) throws IOException {
        this();
        this.type = Type.FILE;
        this.file = file;
        this.dataSource = new FileDataSource(file);
        this.dataSource.checkValid();
    }

    public Attachment(URL url) throws IOException {
        this();
        this.type = Type.URL;
        this.dataSource = new HttpURLDataSource(url);
        this.dataSource.checkValid();
    }

    public Attachment(InputStream inputStream) throws IOException {
        this();
        this.type = Type.INPUTSTREAM;
        this.dataSource = new InputStreamDataSource(inputStream);
        this.dataSource.checkValid();
    }

    protected Attachment(ByteArrayDataSource dataSource) {
        this();
        this.type = Type.INPUTSTREAM;
        this.dataSource = dataSource;
    }

    public InputStream readAsStream() throws IOException {
        return this.dataSource.getInputStream();
    }

    public File readAsFile(String fullFilePath) throws IOException {
        InputStream input = this.readAsStream();
        if (input == null) {
            throw new IOException("no inputstream to save as file");
        }
        FileOutputStream output = new FileOutputStream(fullFilePath);
        try {
            File returnFile;
            byte[] b = new byte[10000];
            int length = 0;
            while ((length = input.read(b)) == 10000) {
                output.write(b, 0, length);
            }
            if (length > 0) {
                output.write(b, 0, length);
            }
            File file = returnFile = new File(fullFilePath);
            return file;
        }
        finally {
            output.close();
        }
    }

    protected Type getType() {
        return this.type;
    }

    protected File getInternalFile() {
        Assert.isTrue((this.getType() == Type.FILE ? 1 : 0) != 0, (String)"invalid type when getting File object");
        return this.file;
    }

    public Object writeReplace() {
        block5: {
            try {
                if (this.type != Type.INPUTSTREAM) break block5;
                try {
                    InputStream input = this.dataSource.getInputStream();
                    if (input != null && input.markSupported()) {
                        input.reset();
                    }
                }
                catch (IOException iOException) {
                    Nop.reason((String)"do nothing");
                }
            }
            catch (Throwable throwable) {
                return new AttachmentSerialized(this.dataSource);
            }
        }
        return new AttachmentSerialized(this.dataSource);
    }

    public Object readResolve() {
        this.dataSource = this.internalDataSource;
        this.type = Type.INPUTSTREAM;
        this.internalDataSource = null;
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Type {
        FILE,
        URL,
        INPUTSTREAM;

    }
}

