/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core.factory;

import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.HessianProtocolException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.hooks.AbstractHooksProxy;
import org.eclipse.riena.communication.core.hooks.CallContext;
import org.eclipse.riena.communication.core.hooks.ICallHook;
import org.eclipse.riena.communication.core.hooks.ICallMessageContext;
import org.eclipse.riena.communication.core.hooks.ICallMessageContextAccessor;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.communication.core.Activator;

public class CallHooksProxy
extends AbstractHooksProxy {
    private final HashSet<ICallHook> callHooks = new HashSet();
    private RemoteServiceDescription rsd;
    private ICallMessageContextAccessor mca;

    public CallHooksProxy(Object proxiedInstance) {
        super(proxiedInstance);
        Wire.instance((Object)this).andStart(Activator.getDefault().getContext());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Iterator<ICallHook> iterator;
        Throwable throwable;
        ICallMessageContext mc = null;
        if (this.mca != null) {
            mc = this.mca.createMessageContext(this.getProxiedInstance(), method.getName(), null);
        }
        CallContext context = new CallContext(this.rsd, method.getName(), mc);
        if (this.callHooks.size() > 0) {
            for (ICallHook sHook : this.callHooks) {
                sHook.beforeCall(context);
            }
        }
        try {
            Object object = super.invoke(proxy, method, args);
            return object;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof HessianRuntimeException || e.getTargetException() instanceof HessianProtocolException) {
                Throwable cause = e.getTargetException();
                while (true) {
                    if (cause.getCause() == null) {
                        throw new RemoteFailure("Error while invoking remote service", e.getTargetException());
                    }
                    if (cause.getCause() instanceof RemoteFailure) {
                        throw cause.getCause();
                    }
                    cause = cause.getCause();
                }
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw e.getTargetException();
            }
            Class<?>[] classArray = method.getExceptionTypes();
            int n = classArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    throw new RemoteFailure("Error while invoking remote service", e.getTargetException());
                }
                Class<?> exceptionType = classArray[n2];
                if (exceptionType.isAssignableFrom(e.getTargetException().getClass())) {
                    throw e.getTargetException();
                }
                ++n2;
            }
        }
        finally {
            context.getMessageContext().fireEndCall();
            if (this.callHooks.size() <= 0) throw throwable;
            iterator = this.callHooks.iterator();
        }
        while (true) {
            if (!iterator.hasNext()) {
                throw throwable;
            }
            ICallHook sHook = iterator.next();
            sHook.afterCall(context);
        }
    }

    @InjectService
    public void bind(ICallHook serviceHook) {
        this.callHooks.add(serviceHook);
    }

    public void unbind(ICallHook serviceHook) {
        this.callHooks.remove(serviceHook);
    }

    public Object getCallProxy() {
        return this.getProxiedInstance();
    }

    public void setRemoteServiceDescription(RemoteServiceDescription rsd) {
        this.rsd = rsd;
    }

    public void setMessageContextAccessor(ICallMessageContextAccessor mca) {
        this.mca = mca;
    }

    public Subject getSubject() {
        return null;
    }
}

