/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core.proxyselector;

import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.communication.core.Activator;
import org.eclipse.riena.internal.communication.core.proxyselector.CompoundProxySelector;
import org.eclipse.riena.internal.communication.core.proxyselector.IProxySelectorExtension;

public class ProxySelectorConfiguration {
    private final ProxySelector previousProxySlector = ProxySelector.getDefault();
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ProxySelectorConfiguration.class);

    @InjectExtension
    public void configure(IProxySelectorExtension[] proxySelectorExtensions) {
        if (proxySelectorExtensions == null || proxySelectorExtensions.length == 0) {
            ProxySelector.setDefault(this.previousProxySlector);
            return;
        }
        Arrays.sort(proxySelectorExtensions, new Comparator<IProxySelectorExtension>(){

            @Override
            public int compare(IProxySelectorExtension e1, IProxySelectorExtension e2) {
                return e1.getOrder() < e2.getOrder() ? -1 : (e1.getOrder() > e2.getOrder() ? 1 : 0);
            }
        });
        LOGGER.log(4, "Configured proxy selectors:");
        ArrayList<ProxySelector> proxySelectors = new ArrayList<ProxySelector>(proxySelectorExtensions.length);
        IProxySelectorExtension[] iProxySelectorExtensionArray = proxySelectorExtensions;
        int n = proxySelectorExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IProxySelectorExtension extension = iProxySelectorExtensionArray[n2];
            ProxySelector proxySelector = extension.createProxySelector();
            LOGGER.log(4, "  - " + extension.getName() + " with order=" + extension.getOrder() + " implemented by " + proxySelector.getClass().getName());
            proxySelectors.add(proxySelector);
            ++n2;
        }
        ProxySelector.setDefault(new CompoundProxySelector(proxySelectors));
    }
}

