/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.core.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.communication.core.IRemoteServiceReference;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.factory.ProxyAlreadyRegisteredFailure;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.internal.communication.core.Activator;
import org.eclipse.riena.internal.communication.core.registry.RemoteServiceRegistration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteServiceRegistry
implements IRemoteServiceRegistry {
    private Map<String, IRemoteServiceRegistration> registeredServices;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), RemoteServiceRegistry.class);

    public synchronized void start() {
        this.registeredServices = new HashMap<String, IRemoteServiceRegistration>();
    }

    public synchronized void stop() {
        IRemoteServiceRegistration[] arrayRS;
        IRemoteServiceRegistration[] iRemoteServiceRegistrationArray = arrayRS = this.registeredServices.values().toArray(new IRemoteServiceRegistration[this.registeredServices.values().size()]);
        int n = arrayRS.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteServiceRegistration serviceReg = iRemoteServiceRegistrationArray[n2];
            this.unregisterService(serviceReg.getReference());
            ++n2;
        }
        this.registeredServices.clear();
        this.registeredServices = null;
    }

    @Override
    public IRemoteServiceRegistration registerService(IRemoteServiceReference reference, BundleContext context) {
        final String url = reference.getDescription().getURL();
        Map<String, IRemoteServiceRegistration> map = this.registeredServices;
        synchronized (map) {
            IRemoteServiceRegistration foundRemoteServiceReg = this.registeredServices.get(url);
            if (foundRemoteServiceReg == null) {
                Properties props = new Properties();
                props.put("service.url", url);
                props.put("service.protocol", reference.getDescription().getProtocol());
                ServiceRegistration serviceRegistration = context.registerService(reference.getServiceInterfaceClassName(), reference.getServiceInstance(), (Dictionary)props);
                try {
                    Activator.getDefault().getContext().addServiceListener(new ServiceListener(){

                        public void serviceChanged(ServiceEvent event) {
                            if (event.getType() == 4) {
                                if (RemoteServiceRegistry.this.registeredServices.containsKey(url)) {
                                    RemoteServiceRegistry.this.registeredServices.remove(url);
                                }
                                Activator.getDefault().getContext().removeServiceListener((ServiceListener)this);
                            }
                        }
                    }, "(service.id=" + serviceRegistration.getReference().getProperty("service.id") + ")");
                }
                catch (InvalidSyntaxException e) {
                    e.printStackTrace();
                }
                reference.setContext(context);
                reference.setServiceRegistration(serviceRegistration);
                RemoteServiceRegistration remoteServiceReg = new RemoteServiceRegistration(reference, this);
                this.registeredServices.put(url, remoteServiceReg);
                LOGGER.log(4, "OSGi NEW service registered id: " + reference.getServiceInterfaceClassName());
                return remoteServiceReg;
            }
            throw new ProxyAlreadyRegisteredFailure("Cannot register two remote service proxies with the same URL. Proxy for " + url + " already exists. Registered by bundle " + foundRemoteServiceReg.getReference().getContext().getBundle().getSymbolicName() + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterService(IRemoteServiceReference reference) {
        Assert.isNotNull((Object)reference, (String)"RemoteServiceReference must not be null");
        Map<String, IRemoteServiceRegistration> map = this.registeredServices;
        synchronized (map) {
            ServiceRegistration serviceRegistration = reference.getServiceRegistration();
            String id = reference.getServiceInterfaceClassName();
            this.registeredServices.remove(reference.getURL());
            reference.dispose();
            serviceRegistration.unregister();
            LOGGER.log(4, "OSGi service removed id: " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IRemoteServiceRegistration> registeredServices(BundleContext context) {
        Map<String, IRemoteServiceRegistration> map = this.registeredServices;
        synchronized (map) {
            Collection<IRemoteServiceRegistration> values = this.registeredServices.values();
            if (context == null) {
                return new ArrayList<IRemoteServiceRegistration>(values);
            }
            ArrayList<IRemoteServiceRegistration> result = new ArrayList<IRemoteServiceRegistration>();
            for (IRemoteServiceRegistration serviceReg : values) {
                BundleContext registeredBundleContext = serviceReg.getReference().getContext();
                if (!context.equals(registeredBundleContext)) continue;
                result.add(serviceReg);
            }
            return result;
        }
    }

    public boolean hasServiceForUrl(String url) {
        return this.registeredServices.get(url) != null;
    }
}

