/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging.log4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.xml.DOMConfigurator;
import org.apache.log4j.xml.Log4jEntityResolver;
import org.apache.log4j.xml.SAXErrorHandler;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.log.ExtendedLogEntry;
import org.eclipse.riena.core.logging.ConsoleLogger;
import org.eclipse.riena.core.logging.log4j.ILog4jDiagnosticContext;
import org.eclipse.riena.core.util.VariableManagerUtil;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.logging.log4j.ILog4jDiagnosticContextExtension;
import org.eclipse.riena.internal.core.logging.log4j.ILog4jLogListenerConfigurationExtension;
import org.osgi.framework.Bundle;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Log4jLogListener
implements LogListener,
IExecutableExtension {
    private ILog4jDiagnosticContext log4jDiagnosticContext;
    public static final String DEFAULT_CONFIGURATION = "/log4j.default.xml";

    public void logged(LogEntry entry) {
        Level level;
        ExtendedLogEntry extendedEntry = (ExtendedLogEntry)entry;
        String loggerName = extendedEntry.getLoggerName();
        Logger logger = Logger.getLogger((String)(loggerName != null ? loggerName : "*unknown-logger-name*"));
        switch (extendedEntry.getLevel()) {
            case 4: {
                level = Level.DEBUG;
                break;
            }
            case 2: {
                level = Level.WARN;
                break;
            }
            case 1: {
                level = Level.ERROR;
                break;
            }
            case 3: {
                level = Level.INFO;
                break;
            }
            default: {
                level = CustomLevel.create(extendedEntry.getLevel());
            }
        }
        ILog4jDiagnosticContext diagnosticContext = this.log4jDiagnosticContext;
        try {
            if (diagnosticContext != null) {
                diagnosticContext.push();
            }
            logger.log((Priority)level, (Object)extendedEntry.getMessage(), extendedEntry.getException());
        }
        finally {
            if (diagnosticContext != null) {
                diagnosticContext.pop();
            }
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data == null) {
            data = DEFAULT_CONFIGURATION;
        }
        if (!(data instanceof String)) {
            return;
        }
        this.configure(config, (String)data);
    }

    protected void configure(IConfigurationElement config, String configuration) throws CoreException {
        Bundle bundle = ContributorFactoryOSGi.resolve((IContributor)config.getContributor());
        this.configure(bundle, configuration);
    }

    protected void configure(Bundle bundle, String configuration) throws CoreException {
        URL url = bundle.getEntry(configuration);
        if (url != null) {
            this.configure(this.createDocument(url).getDocumentElement());
        } else {
            new ConsoleLogger(Log4jLogListener.class.getName()).log(1, "Could not find specified log4j configuration '" + configuration + "' within bundle '" + bundle.getSymbolicName() + "'.");
        }
    }

    private Document createDocument(URL configuration) throws CoreException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setValidating(true);
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new SAXErrorHandler());
            db.setEntityResolver((EntityResolver)new Log4jEntityResolver());
            String xml = VariableManagerUtil.substitute(this.read(configuration.openStream()));
            InputSource inputSource = new InputSource(new StringReader(xml));
            inputSource.setSystemId("dummy://log4j.dtd");
            return db.parse(inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not configure log4j. Parser configuration error.", (Throwable)e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not configure log4j. Unable to parse xml configuration.", (Throwable)e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Could not configure log4j.", (Throwable)e));
        }
    }

    protected void configure(Element root) {
        Thread thread = Thread.currentThread();
        ClassLoader savedClassLoader = thread.getContextClassLoader();
        thread.setContextClassLoader(this.getClass().getClassLoader());
        try {
            DOMConfigurator.configure((Element)root);
        }
        finally {
            thread.setContextClassLoader(savedClassLoader);
        }
    }

    protected String read(InputStream inputStream) throws IOException {
        int ch;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder bob = new StringBuilder();
        while ((ch = reader.read()) != -1) {
            bob.append((char)ch);
        }
        return bob.toString();
    }

    @InjectExtension
    public void update(ILog4jLogListenerConfigurationExtension[] extensions) throws CoreException {
        ILog4jLogListenerConfigurationExtension[] iLog4jLogListenerConfigurationExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            ILog4jLogListenerConfigurationExtension ext = iLog4jLogListenerConfigurationExtensionArray[n2];
            this.configure(ext.getConfigurationElement(), ext.getLocation());
            ++n2;
        }
    }

    @InjectExtension(min=0, max=1)
    public void update(ILog4jDiagnosticContextExtension log4jDiagnosticContextExtension) {
        this.log4jDiagnosticContext = log4jDiagnosticContextExtension == null ? null : log4jDiagnosticContextExtension.createDiagnosticContext();
    }

    private static final class CustomLevel
    extends Level {
        private static final long serialVersionUID = 8076188016013250132L;
        private static Map<Integer, CustomLevel> map = new HashMap<Integer, CustomLevel>();
        private static final int LOG4J_LEVEL = 100000;
        private static final int SYSLOG_APPENDER_LOG_USER = 8;

        private static synchronized CustomLevel create(int osgiLogLevel) {
            Assert.isTrue((osgiLogLevel < 1 ? 1 : 0) != 0, (String)"custom osgi log levels must be below 1");
            CustomLevel customLevel = map.get(osgiLogLevel);
            if (customLevel != null) {
                return customLevel;
            }
            customLevel = new CustomLevel(100000 + Math.abs(osgiLogLevel), "Custom(" + osgiLogLevel + ")", 8);
            map.put(osgiLogLevel, customLevel);
            return customLevel;
        }

        private CustomLevel(int level, String levelStr, int syslogEquivalent) {
            super(level, levelStr, syslogEquivalent);
        }
    }
}

