/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.logging.log4j;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.MDC;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.logging.log4j.ILog4jDiagnosticContext;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.core.util.VariableManagerUtil;

public class Log4jMDCDiagnosticContext
implements ILog4jDiagnosticContext,
IExecutableExtension {
    private final Map<String, String> contextInfo = new HashMap<String, String>();

    public void push() {
        for (Map.Entry<String, String> entry : this.contextInfo.entrySet()) {
            MDC.put((String)entry.getKey(), (Object)entry.getValue());
        }
    }

    public void pop() {
        for (String key : this.contextInfo.keySet()) {
            MDC.remove((String)key);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            for (Map.Entry<String, String> entry : PropertiesUtils.asMap(data, new String[0]).entrySet()) {
                this.contextInfo.put(entry.getKey(), VariableManagerUtil.substitute(entry.getValue()));
            }
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.core", message, (Throwable)e));
    }
}

