/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.marker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.IMarkerAttributeChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMarker
implements IMarker {
    private static final String ATTRIBUTE_UNIQUE = "unique";
    private Map<String, Object> attributeMap = new HashMap<String, Object>(0, 1.0f);
    private Set<IMarkerAttributeChangeListener> attributeChangeListeners = new HashSet<IMarkerAttributeChangeListener>(1, 1.0f);
    private boolean unique;

    public AbstractMarker() {
        this(true);
        this.setAttribute(ATTRIBUTE_UNIQUE, Boolean.TRUE);
    }

    public AbstractMarker(boolean unique) {
        this.unique = unique;
        if (unique) {
            this.setAttribute(ATTRIBUTE_UNIQUE, Boolean.TRUE);
        } else {
            this.setAttribute(ATTRIBUTE_UNIQUE, null);
        }
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    @Override
    public Object getAttribute(String name) {
        Assert.isNotNull((Object)name, (String)"name must not be null");
        return this.attributeMap.get(name);
    }

    @Override
    public Object getAttribute(String name, Object defaultValue) {
        Object value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Map<String, Object> getAttributes() {
        return new HashMap<String, Object>(this.attributeMap);
    }

    @Override
    public void setAttribute(String name, Object value) {
        Assert.isNotNull((Object)name, (String)"name must not be null");
        Object oldValue = this.attributeMap.get(name);
        if (value != null && !value.equals(oldValue) || value == null && oldValue != null) {
            this.attributeMap.put(name, value);
            this.fireAttributesChanged();
        }
    }

    private void fireAttributesChanged() {
        for (IMarkerAttributeChangeListener listener : this.attributeChangeListeners) {
            listener.attributesChanged();
        }
    }

    @Override
    public void addAttributeChangeListener(IMarkerAttributeChangeListener listener) {
        this.attributeChangeListeners.add(listener);
    }

    @Override
    public void removeAttributeChangeListener(IMarkerAttributeChangeListener listener) {
        this.attributeChangeListeners.remove(listener);
    }

    public boolean equals(Object other) {
        if (!(other instanceof AbstractMarker)) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractMarker otherMarker = (AbstractMarker)other;
        return this.getAttributes().equals(otherMarker.getAttributes());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append("[attributes=");
        buffer.append(this.getAttributes());
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public IMarker.Priority getPriority() {
        return IMarker.Priority.NORMAL;
    }
}

