/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.ping;

import java.lang.reflect.Method;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.ping.DefaultPingable;
import org.eclipse.riena.core.ping.IPingable;
import org.eclipse.riena.core.ping.PingFingerprint;
import org.eclipse.riena.core.ping.PingVisitor;

public class PingMethodAdapter
extends DefaultPingable {
    private final Method method;
    private final IPingable pingable;

    public PingMethodAdapter(IPingable pingable, Method method) {
        Assert.isNotNull((Object)pingable, (String)"pingable");
        Assert.isNotNull((Object)method, (String)"method");
        this.pingable = pingable;
        this.method = method;
    }

    public PingVisitor ping(PingVisitor visitor) {
        this.invokePingMethod();
        return visitor.visit(this);
    }

    protected void invokePingMethod() {
        try {
            this.method.invoke((Object)this.pingable, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public PingFingerprint getPingFingerprint() {
        return new PingFingerprint(this.pingable, this.method.getName());
    }

    public boolean equals(Object other) {
        if (!(other instanceof PingMethodAdapter)) {
            return false;
        }
        PingMethodAdapter otherPingableMethodAdapter = (PingMethodAdapter)other;
        return this.pingable == otherPingableMethodAdapter.pingable && this.method.equals(otherPingableMethodAdapter.method);
    }

    public int hashCode() {
        return this.pingable.hashCode() + 7 * this.method.hashCode();
    }

    public String toString() {
        return "PingMethodAdapter[pingable=" + this.pingable + ", method=" + this.method.getName() + "]";
    }
}

