/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.ping;

import java.util.List;
import org.eclipse.riena.core.ping.IPingable;
import org.eclipse.riena.core.ping.PingResult;
import org.eclipse.riena.core.ping.PingVisitor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Sonar {
    private Sonar() {
    }

    public static List<PingResult> pingAllServices() {
        ServiceReference[] allServiceReferences;
        PingVisitor visitor = new PingVisitor();
        BundleContext context = FrameworkUtil.getBundle(Sonar.class).getBundleContext();
        try {
            allServiceReferences = context.getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("This should never happen. We do not use a filter.", e);
        }
        if (allServiceReferences == null) {
            return null;
        }
        ServiceReference[] serviceReferenceArray = allServiceReferences;
        int n = allServiceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceReference = serviceReferenceArray[n2];
            Object service = context.getService(serviceReference);
            if (service instanceof IPingable) {
                IPingable pingable = (IPingable)service;
                visitor = pingable.ping(visitor);
            }
            ++n2;
        }
        return visitor.getPingResults();
    }
}

