/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.RichString;
import org.eclipse.riena.core.util.UtilFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Orderer<T> {
    private final List<Ordering<T>> orderingsList = new ArrayList<Ordering<T>>();
    private final Map<String, Ordering<T>> orderingsMap = new HashMap<String, Ordering<T>>();
    private Node<T> leader;
    private Node<T> trailer;
    private static final String HIGHEST_DEPENDENCY = "*";
    private static final Logger LOGGER = Log4r.getLogger(Orderer.class);

    public void add(T object, String name, String preReqs, String postReqs) {
        Ordering<T> ordering = this.getOrderable(name);
        if (ordering != null) {
            throw new OrdererFailure("More then one object with the name '" + name + "'.");
        }
        ordering = new Ordering<T>(object, name, preReqs, postReqs);
        this.orderingsMap.put(name, ordering);
        this.orderingsList.add(ordering);
    }

    private Ordering<T> getOrderable(String name) {
        return this.orderingsMap.get(name);
    }

    public List<T> getOrderedObjects() {
        if (this.orderingsMap.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Ordering<T>, Node<T>> nodeMap = new HashMap<Ordering<T>, Node<T>>();
        this.initializeGraph(nodeMap);
        return this.trailer.getOrder();
    }

    private void initializeGraph(Map<Ordering<T>, Node<T>> nodeMap) {
        this.addNodes(nodeMap);
        if (this.leader == null) {
            this.leader = new Node<Object>(null, "*-leader-*");
        }
        if (this.trailer == null) {
            this.trailer = new Node<Object>(null, "*-trailer-*");
        }
        this.addDependencies(nodeMap);
    }

    private Node<T> getNode(Map<Ordering<T>, Node<T>> nodeMap, String name) {
        return nodeMap.get(this.getOrderable(name));
    }

    private void addNodes(Map<Ordering<T>, Node<T>> nodeMap) {
        for (Ordering<T> ordering : this.orderingsList) {
            Node<T> node = new Node<T>(ordering.getObject(), ordering.getName());
            nodeMap.put(ordering, node);
            if (HIGHEST_DEPENDENCY.equals(ordering.getPostReqs())) {
                if (this.leader != null) {
                    throw new OrdererFailure("More than one leader. Conflicting '" + this.leader.getName() + "' (ordered unknown) and '" + node.getName() + "' (first).");
                }
                this.leader = node;
            }
            if (!HIGHEST_DEPENDENCY.equals(ordering.getPreReqs())) continue;
            if (this.trailer != null) {
                throw new OrdererFailure("More than one trailer. Conflicting '" + this.trailer.getName() + "' (ordered unknown) and '" + node.getName() + "' (last).");
            }
            this.trailer = node;
        }
    }

    private void addDependencies(Map<Ordering<T>, Node<T>> nodeMap) {
        for (Ordering<T> ordering : this.orderingsList) {
            this.addDependencies(nodeMap, ordering, this.getNode(nodeMap, ordering.getName()));
        }
    }

    private void addDependencies(Map<Ordering<T>, Node<T>> nodeMap, Ordering<T> orderable, Node<T> node) {
        this.addPreReqs(nodeMap, orderable, node);
        this.addPostReqs(nodeMap, orderable, node);
        if (node != this.leader) {
            node.addDependency(this.leader);
        }
        if (node != this.trailer) {
            this.trailer.addDependency(node);
        }
    }

    private void addPreReqs(Map<Ordering<T>, Node<T>> nodeMap, Ordering<T> ordering, Node<T> node) {
        String preReqs = ordering.getPreReqs();
        if (HIGHEST_DEPENDENCY.equals(preReqs)) {
            return;
        }
        List<String> names = new RichString(preReqs).toList();
        for (String beforeName : names) {
            Node<T> beforeNode = this.getNode(nodeMap, beforeName);
            if (beforeNode == null) {
                if (beforeName.length() <= 0) continue;
                LOGGER.log(2, "bad dependency: " + beforeName + ", " + ordering);
                continue;
            }
            node.addDependency(beforeNode);
        }
    }

    private void addPostReqs(Map<Ordering<T>, Node<T>> nodeMap, Ordering<T> ordering, Node<T> node) {
        String postReqs = ordering.getPostReqs();
        if (HIGHEST_DEPENDENCY.equals(postReqs)) {
            return;
        }
        List<String> names = new RichString(postReqs).toList();
        for (String afterName : names) {
            Node<T> afterNode = this.getNode(nodeMap, afterName);
            if (afterNode == null) {
                if (afterName.length() <= 0) continue;
                LOGGER.log(2, "bad dependency: " + afterName + ", " + ordering);
                continue;
            }
            afterNode.addDependency(node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Node<T> {
        private final T object;
        private final String name;
        private final List<Node<T>> dependencies = new ArrayList<Node<T>>();

        public Node(T object, String name) {
            this.object = object;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addDependency(Node<T> node) {
            if (super.isReachable(this)) {
                throw new OrdererFailure("A cycle has been detected between '" + this.name + "' and '" + node.getName() + "'.");
            }
            this.dependencies.add(node);
        }

        private boolean isReachable(Node<T> node) {
            boolean reachable = node == this;
            for (Node<T> dependency : this.dependencies) {
                if (reachable) {
                    return true;
                }
                boolean bl = reachable = dependency == node ? true : super.isReachable(node);
            }
            return reachable;
        }

        public List<T> getOrder() {
            ArrayList result = new ArrayList();
            this.fillOrder(result);
            return result;
        }

        private void fillOrder(List<T> result) {
            if (result.contains(this.object)) {
                return;
            }
            for (Node<T> dependency : this.dependencies) {
                super.fillOrder(result);
            }
            if (this.object != null) {
                result.add(this.object);
            }
        }
    }

    public static class OrdererFailure
    extends UtilFailure {
        private static final long serialVersionUID = 5018828794366775202L;

        public OrdererFailure(String msg) {
            super(msg);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ordering<T> {
        private final T object;
        private final String name;
        private final String preReqs;
        private final String postReqs;

        Ordering(T object, String name, String preReqs, String postReqs) {
            this.object = object;
            this.name = name;
            this.preReqs = preReqs;
            this.postReqs = postReqs;
        }

        public String getName() {
            return this.name;
        }

        public T getObject() {
            return this.object;
        }

        public String getPostReqs() {
            return this.postReqs;
        }

        public String getPreReqs() {
            return this.preReqs;
        }

        public String toString() {
            return "Ordering [name=" + this.name + ", preReqs=" + this.preReqs + ", postReqs=" + this.postReqs + "]";
        }
    }
}

