/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.wire;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.injector.IStoppable;
import org.eclipse.riena.core.injector.extension.ExtensionInjector;
import org.eclipse.riena.core.injector.service.ServiceInjector;
import org.eclipse.riena.core.util.Iter;
import org.eclipse.riena.core.wire.IWiring;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.core.wire.WireWith;
import org.eclipse.riena.internal.core.wire.ExtensionInjectorBuilder;
import org.eclipse.riena.internal.core.wire.ServiceInjectorBuilder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WirePuller
implements IStoppable {
    private final Object bean;
    private BundleContext context;
    private List<IWiring> wirings;
    private List<IStoppable> injections;
    private State state = State.PENDING;
    private BundleListener bundleStoppingListener;
    private static Map<Class<?>, Class<? extends IWiring>> wiringMocks;

    WirePuller(Object bean) {
        Assert.isLegal((bean != null ? 1 : 0) != 0, (String)"bean must exist");
        this.bean = bean;
    }

    public synchronized WirePuller andStart(BundleContext context) {
        Assert.isLegal((context != null ? 1 : 0) != 0, (String)"context must be given.");
        Assert.isLegal((this.state == State.PENDING ? 1 : 0) != 0, (String)"state must be pending.");
        this.context = context;
        this.wire(this.bean.getClass());
        this.state = State.STARTED;
        this.bundleStoppingListener = new BundleStoppingListener();
        context.addBundleListener(this.bundleStoppingListener);
        return this;
    }

    @Override
    public synchronized void stop() {
        if (this.state != State.STARTED) {
            return;
        }
        this.context.removeBundleListener(this.bundleStoppingListener);
        if (this.wirings != null) {
            for (IWiring wiring : this.wirings) {
                wiring.unwire(this.bean, this.context);
            }
        }
        if (this.injections != null) {
            for (IStoppable stoppable : Iter.ableReverse(this.injections)) {
                stoppable.stop();
            }
        }
        this.state = State.STOPPED;
    }

    private void wire(Class<?> beanClass) {
        if (beanClass == null || beanClass == Object.class) {
            return;
        }
        IWiring wiring = this.getWiring(this.getWiringClass(beanClass));
        this.add(wiring);
        this.wire(beanClass.getSuperclass());
        if (wiring != null) {
            wiring.wire(this.bean, this.context);
        }
        this.injectIntoAnnotatedMethods(this.bean, beanClass);
    }

    private void injectIntoAnnotatedMethods(Object bean, Class<?> beanClass) {
        Method[] methodArray = beanClass.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(InjectService.class)) {
                this.injectServiceInto(bean, method);
            } else if (method.isAnnotationPresent(InjectExtension.class)) {
                this.injectExtensionInto(bean, method);
            }
            ++n2;
        }
    }

    private void injectServiceInto(Object bean, Method method) {
        ServiceInjectorBuilder bob = new ServiceInjectorBuilder(bean, method);
        ServiceInjector injector = bob.build();
        this.add(injector.andStart(this.context));
    }

    private void injectExtensionInto(Object bean, Method method) {
        ExtensionInjectorBuilder bob = new ExtensionInjectorBuilder(bean, method);
        ExtensionInjector injector = bob.build();
        this.add(injector.andStart(this.context));
    }

    private void add(IWiring wiring) {
        if (wiring == null) {
            return;
        }
        if (this.wirings == null) {
            this.wirings = new ArrayList<IWiring>(2);
        }
        this.wirings.add(wiring);
    }

    private void add(IStoppable stoppable) {
        if (this.injections == null) {
            this.injections = new ArrayList<IStoppable>();
        }
        this.injections.add(stoppable);
    }

    private IWiring getWiring(Class<? extends IWiring> wiringClass) {
        if (wiringClass == null) {
            return null;
        }
        try {
            return wiringClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Could not create instance of wiring " + wiringClass, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Could not create instance of wiring " + wiringClass, e);
        }
    }

    private Class<? extends IWiring> getWiringClass(Class<?> beanClass) {
        if (wiringMocks != null) {
            return wiringMocks.get(beanClass);
        }
        WireWith wiringAnnotation = beanClass.getAnnotation(WireWith.class);
        if (wiringAnnotation != null) {
            return wiringAnnotation.value();
        }
        return null;
    }

    public static void injectWiringMocks(Map<Class<?>, Class<? extends IWiring>> wiringMocks) {
        WirePuller.wiringMocks = wiringMocks;
    }

    private class BundleStoppingListener
    implements SynchronousBundleListener {
        private BundleStoppingListener() {
        }

        public void bundleChanged(BundleEvent event) {
            if (event.getBundle() != WirePuller.this.context.getBundle()) {
                return;
            }
            if (event.getType() == 256) {
                WirePuller.this.stop();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STARTED,
        STOPPED,
        PENDING;

    }
}

