/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.exceptionmanager;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.exception.IExceptionHandler;
import org.eclipse.riena.core.exception.IExceptionHandlerManager;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.core.Activator;
import org.eclipse.riena.internal.core.exceptionmanager.IExceptionHandlerExtension;
import org.eclipse.riena.internal.core.exceptionmanager.TopologicalNode;
import org.eclipse.riena.internal.core.exceptionmanager.TopologicalSort;

public class SimpleExceptionHandlerManager
implements IExceptionHandlerManager {
    private List<IExceptionHandler> handlers;
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SimpleExceptionHandlerManager.class);

    @InjectExtension
    public void update(IExceptionHandlerExtension[] exceptionHandlerDefinitions) {
        ArrayList nodes = new ArrayList(exceptionHandlerDefinitions.length);
        IExceptionHandlerExtension[] iExceptionHandlerExtensionArray = exceptionHandlerDefinitions;
        int n = exceptionHandlerDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionHandlerExtension handlerDefinition = iExceptionHandlerExtensionArray[n2];
            IExceptionHandler exceptionHandler = handlerDefinition.createExceptionHandler();
            if (exceptionHandler == null) {
                LOGGER.log(1, "could not instantiate exception handler " + handlerDefinition.getName() + " for class " + handlerDefinition.getExceptionHandler());
            }
            nodes.add(new TopologicalNode<IExceptionHandler>(handlerDefinition.getName(), handlerDefinition.getBefore(), exceptionHandler));
            ++n2;
        }
        this.handlers = TopologicalSort.sort(nodes);
    }

    public IExceptionHandler.Action handleException(Throwable t) {
        return this.handleException(t, null, LOGGER);
    }

    public IExceptionHandler.Action handleException(Throwable t, Logger logger) {
        return this.handleException(t, null, logger);
    }

    public IExceptionHandler.Action handleException(Throwable t, String msg) {
        return this.handleException(t, msg, LOGGER);
    }

    public IExceptionHandler.Action handleException(Throwable t, String msg, Logger logger) {
        for (IExceptionHandler handler : this.handlers) {
            IExceptionHandler.Action action = handler.handleException(t, msg, logger);
            if (action == IExceptionHandler.Action.NOT_HANDLED) continue;
            return action;
        }
        return IExceptionHandler.Action.NOT_HANDLED;
    }
}

