/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.core.logging;

import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.core.logging.DeferringLoggerFactory;
import org.eclipse.riena.internal.core.logging.LoggerMill;
import org.osgi.framework.FrameworkUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LoggerProvider {
    private boolean started;
    private final LoggerMill loggerMill = new LoggerMill();
    private static final LoggerProvider INSTANCE = new LoggerProvider();

    public static LoggerProvider instance() {
        return INSTANCE;
    }

    private LoggerProvider() {
    }

    public synchronized void start() {
        if (!this.started) {
            this.started = true;
            Wire.instance(this.loggerMill).andStart(FrameworkUtil.getBundle(LoggerProvider.class).getBundleContext());
        }
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            Nop.reason("Maybe we tear down the wire puller here");
        }
    }

    public Logger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String name) {
        if (this.loggerMill.isReady()) {
            return this.loggerMill.getLogger(name);
        }
        return DeferringLoggerFactory.createLogger(name, this);
    }

    Logger getRealLogger(String name) {
        if (!this.loggerMill.isReady()) {
            return null;
        }
        return this.loggerMill.getLogger(name);
    }

    boolean hasReadyLoggerMill() {
        return this.loggerMill.isReady();
    }
}

