/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.controllers;

import java.util.Date;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.demo.client.controllers.SearchBean;
import org.eclipse.riena.demo.client.controllers.SearchResult;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.demo.common.ICustomerService;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.DateColumnFormatter;

public class CustomerSearchController
extends SubModuleController {
    private ICustomerService customerDemoService;
    private SearchBean customerSearchBean = new SearchBean();
    private SearchResult result = new SearchResult();

    @InjectService(useRanking=true)
    public void bind(ICustomerService customerDemoService) {
        this.customerDemoService = customerDemoService;
    }

    public void unbind(ICustomerService customerDemoService) {
        this.customerDemoService = null;
    }

    public void configureRidgets() {
        ITextRidget suchName = (ITextRidget)this.getRidget("searchLastName");
        suchName.bindToModel((Object)this.customerSearchBean, "lastName");
        suchName.setMandatory(true);
        ((ILabelRidget)this.getRidget("hits")).bindToModel((Object)this.result, "hits");
        final ITableRidget kunden = (ITableRidget)this.getRidget("result");
        String[] columnNames = new String[]{"lastname", "firstname", "birthdate", "street", "city"};
        String[] propertyNames = new String[]{"lastName", "firstName", "birthDate", "address.street", "address.city"};
        kunden.bindToModel((Object)this.result, "customers", Customer.class, propertyNames, columnNames);
        kunden.setColumnFormatter(2, (IColumnFormatter)new DateColumnFormatter("dd.MM.yyyy"){

            protected Date getDate(Object element) {
                return ((Customer)element).getBirthDate();
            }
        });
        ((IActionRidget)this.getRidget("search")).addListener(new IActionListener(){

            public void callback() {
                CustomerSearchController.this.result.setCustomers(null);
                CustomerSearchController.this.getRidget("result").updateFromModel();
                CustomerSearchController.this.result.setCustomers(CustomerSearchController.this.customerDemoService.search(null));
                CustomerSearchController.this.getRidget("result").updateFromModel();
                CustomerSearchController.this.getRidget("hits").updateFromModel();
            }
        });
        ((IActionRidget)this.getRidget("new")).addListener(new IActionListener(){

            public void callback() {
                ((ISubModuleNode)CustomerSearchController.this.getNavigationNode()).navigate(new NavigationNodeId("riena.demo.client.CustomerRecord"));
            }
        });
        ((IActionRidget)this.getRidget("open")).addListener(new IActionListener(){

            public void callback() {
                int selectionIndex = kunden.getSelectionIndex();
                if (selectionIndex >= 0) {
                    ((ISubModuleNode)CustomerSearchController.this.getNavigationNode()).navigate(new NavigationNodeId("riena.demo.client.CustomerRecord", CustomerSearchController.this.result.getCustomers().get(selectionIndex).getEmailAddress()), new NavigationArgument((Object)CustomerSearchController.this.result.getCustomers().get(selectionIndex)));
                }
            }
        });
    }
}

