/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.demo.client.controllers;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.riena.demo.client.controllers.AbstractEmailController;
import org.eclipse.riena.demo.common.Customer;
import org.eclipse.riena.demo.common.Email;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.ui.ridgets.IColumnFormatter;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.DateColumnFormatter;

public class EmailCustomerController
extends AbstractEmailController {
    private List<Email> customerEmailsList = new ArrayList<Email>();

    public void configureRidgets() {
        super.configureRidgets();
        ITableRidget emails = (ITableRidget)this.getRidget("emailsTable");
        String[] columnHeaders = new String[]{"Subject", "Date"};
        String[] columnPropertyNames = new String[]{"emailSubject", "emailDate"};
        emails.bindToModel((Object)this.emailsResult, "emails", Email.class, columnPropertyNames, columnHeaders);
        emails.setColumnFormatter(1, (IColumnFormatter)new DateColumnFormatter("dd.MMM. HH:mm"){

            protected Date getDate(Object element) {
                return ((Email)element).getEmailDate();
            }
        });
        if (((ISubModuleNode)this.getNavigationNode()).getNavigationArgument().getParameter() instanceof Customer) {
            Customer customer = (Customer)((ISubModuleNode)this.getNavigationNode()).getNavigationArgument().getParameter();
            String emailAddress = customer.getEmailAddress();
            this.customerEmailsList = this.mailDemoService.findEmailsForCustomer(emailAddress);
        }
        this.emailsResult.setEmails(this.customerEmailsList);
        this.getRidget("emailsTable").updateFromModel();
    }
}

