/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.communication;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitor;
import org.eclipse.riena.communication.core.progressmonitor.IRemoteProgressMonitorRegistry;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.example.client.communication.ServiceProgressVisualizer;
import org.eclipse.riena.internal.example.client.Activator;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteCallProcess<T>
extends UIProcess {
    private IRemoteProgressMonitorRegistry registry;
    private ServiceProgressVisualizer serviceProgressVisalizer;

    public RemoteCallProcess(String name, boolean user, Object context) {
        super(name, user, context);
        this.injectRegistry();
    }

    private void injectRegistry() {
        Inject.service(IRemoteProgressMonitorRegistry.class).into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void bind(IRemoteProgressMonitorRegistry registry) {
        this.registry = registry;
    }

    public void unbind(IRemoteProgressMonitorRegistry registry) {
        this.registry = null;
    }

    protected void beforeRun(IProgressMonitor monitor) {
        super.beforeRun(monitor);
        this.serviceProgressVisalizer = new ServiceProgressVisualizer(this.getJob().getName(), monitor);
        this.registerRemoteServiceMonitor();
    }

    protected void afterRun(IProgressMonitor monitor) {
        super.afterRun(monitor);
        this.unregisterRemoteServiceMonitor();
    }

    private void registerRemoteServiceMonitor() {
        this.registry.addProgressMonitor(this.getService(), (IRemoteProgressMonitor)this.serviceProgressVisalizer, this.getServiceMonitorType());
    }

    private void unregisterRemoteServiceMonitor() {
        this.registry.removeProgressMonitor((IRemoteProgressMonitor)this.serviceProgressVisalizer);
    }

    protected abstract T getService();

    protected IRemoteProgressMonitorRegistry.RemovalPolicy getServiceMonitorType() {
        return IRemoteProgressMonitorRegistry.RemovalPolicy.AFTER_ONE_CALL;
    }

    protected boolean forceMonitorBegin() {
        return false;
    }
}

