/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.PersonManager;
import org.eclipse.riena.beans.common.TypedComparator;
import org.eclipse.riena.internal.example.client.beans.PersonModificationBean;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IToggleButtonRidget;

public class ListSubModuleController
extends SubModuleController {
    private final PersonManager manager = new PersonManager((Collection)PersonFactory.createPersonList());
    private PersonModificationBean value;
    private ITableRidget listPersons;

    public ListSubModuleController() {
        this(null);
    }

    public ListSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.manager.setSelectedPerson((Person)this.manager.getPersons().iterator().next());
        this.value = new PersonModificationBean();
    }

    public void configureRidgets() {
        this.listPersons = (ITableRidget)this.getRidget("listPersons");
        this.listPersons.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.listPersons.setComparator(0, (Comparator)new TypedComparator());
        this.listPersons.setSortedColumn(0);
        this.listPersons.bindToModel((Object)this.manager, "persons", Person.class, new String[]{"listEntry"}, null);
        this.listPersons.updateFromModel();
        this.listPersons.bindSingleSelectionToModel((Object)this.manager, "selectedPerson");
        final ITextRidget textFirst = (ITextRidget)this.getRidget("textFirst");
        textFirst.bindToModel((Object)this.value, "firstName");
        textFirst.updateFromModel();
        final ITextRidget textLast = (ITextRidget)this.getRidget("textLast");
        textLast.bindToModel((Object)this.value, "lastName");
        textLast.updateFromModel();
        this.listPersons.addPropertyChangeListener("selection", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ListSubModuleController.this.value.setPerson(ListSubModuleController.this.manager.getSelectedPerson());
                textFirst.updateFromModel();
                textLast.updateFromModel();
            }
        });
        final IToggleButtonRidget buttonSort = (IToggleButtonRidget)this.getRidget("buttonSort");
        buttonSort.setText("Sort ascending");
        buttonSort.setSelected(true);
        this.listPersons.setSortedAscending(buttonSort.isSelected());
        buttonSort.addListener(new IActionListener(){

            public void callback() {
                boolean ascending = buttonSort.isSelected();
                ListSubModuleController.this.listPersons.setSortedAscending(ascending);
            }
        });
        IActionRidget buttonAdd = (IActionRidget)this.getRidget("buttonAdd");
        buttonAdd.setText("&Add");
        buttonAdd.addListener(new IActionListener(){
            private int count = 0;

            public void callback() {
                Person newPerson = new Person("Average", "Joe #" + ++this.count);
                ListSubModuleController.this.manager.getPersons().add(newPerson);
                ListSubModuleController.this.listPersons.updateFromModel();
                ListSubModuleController.this.manager.setSelectedPerson(newPerson);
                ListSubModuleController.this.listPersons.updateSingleSelectionFromModel();
            }
        });
        IActionRidget buttonRemove = (IActionRidget)this.getRidget("buttonRemove");
        buttonRemove.setText("&Remove");
        buttonRemove.addListener(new IActionListener(){

            public void callback() {
                Person selPerson = ListSubModuleController.this.manager.getSelectedPerson();
                if (selPerson != null) {
                    ListSubModuleController.this.manager.getPersons().remove(selPerson);
                    ListSubModuleController.this.listPersons.updateFromModel();
                    ListSubModuleController.this.manager.setSelectedPerson(null);
                }
            }
        });
        IActionRidget buttonSave = (IActionRidget)this.getRidget("buttonSave");
        buttonSave.setText("&Save");
        buttonSave.addListener(new IActionListener(){

            public void callback() {
                ListSubModuleController.this.value.update();
                ListSubModuleController.this.listPersons.updateFromModel();
            }
        });
        final IObservableValue viewerSelection = this.listPersons.getSingleSelectionObservable();
        ComputedValue hasSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                return viewerSelection.getValue() != null;
            }
        };
        DataBindingContext dbc = new DataBindingContext();
        this.bindEnablementToValue(dbc, (IRidget)buttonRemove, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonSave, (IObservableValue)hasSelection);
        if (((ISubModuleNode)this.getNavigationNode()).getNavigationArgument() != null) {
            this.setValuesFromNavigation();
        }
    }

    private void setValuesFromNavigation() {
        NavigationArgument navigationArgument = ((ISubModuleNode)this.getNavigationNode()).getNavigationArgument();
        if (navigationArgument.getParameter() instanceof Integer) {
            int modelIndex = (Integer)navigationArgument.getParameter();
            this.listPersons.setSelection(modelIndex);
        }
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }
}

