/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.internal.example.client.beans.PersonModificationBean;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationArgument;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.NodePositioner;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;

public class NavigateSubModuleController
extends SubModuleController {
    public NavigateSubModuleController() {
        this(null);
    }

    public NavigateSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        IActionRidget comboAndList = (IActionRidget)this.getRidget(IActionRidget.class, "comboAndList");
        comboAndList.setText("Combo and List (SubApplication 1)");
        comboAndList.addListener((IActionListener)new ComboAndListListener());
        IActionRidget tableTextAndTree = (IActionRidget)this.getRidget(IActionRidget.class, "tableTextAndTree");
        tableTextAndTree.setText("Table, Text and Tree (SubApplication 2) [First Position]");
        tableTextAndTree.addListener((IActionListener)new TableTextAndTreeListener());
        IActionRidget textAssembly = (IActionRidget)this.getRidget(IActionRidget.class, "textAssembly");
        textAssembly.setText("Text Assembly (SubApplication 1)");
        textAssembly.addListener((IActionListener)new TextAssemblyListener());
        IActionRidget openAsFirstModule = (IActionRidget)this.getRidget(IActionRidget.class, "openAsFirstModule");
        openAsFirstModule.setText("Open Module As First");
        openAsFirstModule.addListener((IActionListener)new OpenModuleAsFirstListener());
        IActionRidget openAsFirstSubModule = (IActionRidget)this.getRidget(IActionRidget.class, "openAsFirstSubModule");
        openAsFirstSubModule.setText("Open SubModule As FIRST in 'Combo And List'");
        openAsFirstSubModule.addListener((IActionListener)new OpenSubModuleAsFirstListener());
        IActionRidget openAsThirdSubModule = (IActionRidget)this.getRidget(IActionRidget.class, "openAsThirdSubModule");
        openAsThirdSubModule.setText("Open SubModule As THIRD in 'Combo And List'");
        openAsThirdSubModule.addListener((IActionListener)new OpenSubModuleAsThirdListener());
        IActionRidget openAsOrdinal10 = (IActionRidget)this.getRidget(IActionRidget.class, "openAsOrdinal10");
        openAsOrdinal10.setText("Open SubModule with ORDINAL index 10");
        openAsOrdinal10.addListener((IActionListener)new OpenSubModuleOrdinal10Listener());
        IActionRidget openAsOrdinal5 = (IActionRidget)this.getRidget(IActionRidget.class, "openAsOrdinal5");
        openAsOrdinal5.setText("Open SubModule with ORDINAL index 5");
        openAsOrdinal5.addListener((IActionListener)new OpenSubModuleOrdinal5Listener());
        IActionRidget addToModule = (IActionRidget)this.getRidget(IActionRidget.class, "addToModule");
        addToModule.setText("Add SubModule to current Module at index 2");
        addToModule.addListener((IActionListener)new AddSubModuleToCurrentModule());
        IActionRidget moveModule = (IActionRidget)this.getRidget(IActionRidget.class, "moveModule");
        moveModule.setText("Move Active Module");
        moveModule.addListener((IActionListener)new MoveActiveModule());
        IActionRidget moveInActiveModule = (IActionRidget)this.getRidget(IActionRidget.class, "moveInActiveModule");
        moveInActiveModule.setText("Move Inactive Module");
        moveInActiveModule.addListener((IActionListener)new MoveInActiveModule());
        IActionRidget demoTarget = (IActionRidget)this.getRidget(IActionRidget.class, "jumpToTarget");
        demoTarget.setText("Jump To Target");
        demoTarget.addListener((IActionListener)new JumpToTarget());
        final PersonModificationBean bean = new PersonModificationBean();
        bean.setPerson(new Person("Doe", "Jane"));
        IActionRidget navigateRidget = (IActionRidget)this.getRidget(IActionRidget.class, "btnNavigateToRidget");
        navigateRidget.addListener(new IActionListener(){

            public void callback() {
                ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.combo"), new NavigationArgument((Object)bean, "textFirst"));
            }
        });
    }

    private class AddSubModuleToCurrentModule
    implements IActionListener {
        private int instanceId = 1;

        private AddSubModuleToCurrentModule() {
        }

        public void callback() {
            NavigationArgument naviAgr = new NavigationArgument();
            naviAgr.setNodePositioner(NodePositioner.indexed((int)2));
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).create(new NavigationNodeId("org.eclipse.riena.example.navigate.submoduleToModuleAtIndex2", String.valueOf(this.instanceId++)), naviAgr);
        }
    }

    private class ComboAndListListener
    implements IActionListener {
        private ComboAndListListener() {
        }

        public void callback() {
            NavigationArgument naviAgr = new NavigationArgument((Object)new Integer(2));
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.navigate.comboAndList"), naviAgr);
        }
    }

    private class JumpToTarget
    implements IActionListener {
        private JumpToTarget() {
        }

        public void callback() {
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).jump(new NavigationNodeId("org.eclipse.riena.example.navigate.demotarget"));
        }
    }

    private class MoveActiveModule
    implements IActionListener {
        private MoveActiveModule() {
        }

        public void callback() {
            ((ModuleNode)((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).getParentOfType(ModuleNode.class)).moveTo(new NavigationNodeId("org.eclipse.riena.example.moduleGroup1.1.1"));
        }
    }

    private class MoveInActiveModule
    implements IActionListener {
        private MoveInActiveModule() {
        }

        public void callback() {
            ModuleNode moduleNode = (ModuleNode)((SubApplicationNode)((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).getParentOfType(SubApplicationNode.class)).findNode(new NavigationNodeId("org.eclipse.riena.example.module.1.1.1"));
            moduleNode.moveTo(((ModuleGroupNode)((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).getParentOfType(ModuleGroupNode.class)).getNodeId());
        }
    }

    private class OpenModuleAsFirstListener
    implements IActionListener {
        private OpenModuleAsFirstListener() {
        }

        public void callback() {
            NavigationArgument naviAgr = new NavigationArgument();
            naviAgr.setNodePositioner(NodePositioner.ADD_BEGINNING);
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.navigate.firstmodule"), naviAgr);
        }
    }

    private class OpenSubModuleAsFirstListener
    implements IActionListener {
        private OpenSubModuleAsFirstListener() {
        }

        public void callback() {
            NavigationArgument naviAgr = new NavigationArgument();
            naviAgr.setNodePositioner(NodePositioner.ADD_BEGINNING);
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.navigate.firstSubModule"), naviAgr);
        }
    }

    private class OpenSubModuleAsThirdListener
    implements IActionListener {
        private OpenSubModuleAsThirdListener() {
        }

        public void callback() {
            NavigationArgument naviAgr = new NavigationArgument();
            naviAgr.setNodePositioner(NodePositioner.indexed((int)2));
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.navigate.thirdSubModule"), naviAgr);
        }
    }

    private class OpenSubModuleOrdinal10Listener
    implements IActionListener {
        private OpenSubModuleOrdinal10Listener() {
        }

        public void callback() {
            NavigationArgument naviAgr = new NavigationArgument();
            naviAgr.setNodePositioner(NodePositioner.ordinal((int)10));
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.navigate.ordinal10SubModule"), naviAgr);
        }
    }

    private class OpenSubModuleOrdinal5Listener
    implements IActionListener {
        private OpenSubModuleOrdinal5Listener() {
        }

        public void callback() {
            NavigationArgument naviAgr = new NavigationArgument();
            naviAgr.setNodePositioner(NodePositioner.ordinal((int)5));
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.navigate.ordinal5SubModule"), naviAgr);
        }
    }

    private class TableTextAndTreeListener
    implements IActionListener {
        private TableTextAndTreeListener() {
        }

        public void callback() {
            NavigationArgument naviAgr = new NavigationArgument();
            naviAgr.setNodePositioner(NodePositioner.ADD_BEGINNING);
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.navigate.tableTextAndTree"), naviAgr);
        }
    }

    private class TextAssemblyListener
    implements IActionListener {
        private TextAssemblyListener() {
        }

        public void callback() {
            ((ISubModuleNode)NavigateSubModuleController.this.getNavigationNode()).navigate(new NavigationNodeId("org.eclipse.riena.example.client.textExamplesGroup"));
        }
    }
}

