/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.riena.ui.ridgets.tree2.TreeNode;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class TreeSubModuleController
extends SubModuleController {
    private int nodeCount = 0;
    private IActionRidget buttonRename;
    private ITreeRidget tree;

    public TreeSubModuleController() {
        this(null);
    }

    public TreeSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void afterBind() {
        super.afterBind();
        this.bindModel();
    }

    private void bindModel() {
        this.tree.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        Object[] roots = this.createTreeInput();
        this.tree.setRootsVisible(false);
        this.tree.bindToModel(roots, TreeNode.class, "children", "parent", "value", "enabled", "visible");
        this.tree.setSelection(roots[0].getChildren().get(0));
    }

    public void configureRidgets() {
        this.tree = (ITreeRidget)this.getRidget("tree");
        IActionRidget buttonAddSibling = (IActionRidget)this.getRidget("buttonAddSibling");
        IActionRidget buttonAddChild = (IActionRidget)this.getRidget("buttonAddChild");
        this.buttonRename = (IActionRidget)this.getRidget("buttonRename");
        IActionRidget buttonDelete = (IActionRidget)this.getRidget("buttonDelete");
        IActionRidget buttonExpand = (IActionRidget)this.getRidget("buttonExpand");
        IActionRidget buttonCollapse = (IActionRidget)this.getRidget("buttonCollapse");
        IActionRidget buttonDisable = (IActionRidget)this.getRidget("buttonDisable");
        IActionRidget buttonEnable = (IActionRidget)this.getRidget("buttonEnable");
        IActionRidget buttonHide = (IActionRidget)this.getRidget("buttonHide");
        IActionRidget buttonShow = (IActionRidget)this.getRidget("buttonShow");
        buttonAddSibling.setText("Add &Sibling");
        buttonAddSibling.addListener(new IActionListener(){

            public void callback() {
                ITreeNode parent;
                ITreeNode node = (ITreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                ITreeNode iTreeNode = parent = node != null ? node.getParent() : null;
                if (parent != null) {
                    StringBuilder stringBuilder = new StringBuilder("SIBLING ");
                    TreeSubModuleController treeSubModuleController = TreeSubModuleController.this;
                    int n = treeSubModuleController.nodeCount;
                    treeSubModuleController.nodeCount = n + 1;
                    new TreeNode(parent, (Object)stringBuilder.append(n).toString());
                }
            }
        });
        buttonAddChild.setText("Add &Child");
        buttonAddChild.addListener(new IActionListener(){

            public void callback() {
                ITreeNode node = (ITreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    StringBuilder stringBuilder = new StringBuilder("CHILD ");
                    TreeSubModuleController treeSubModuleController = TreeSubModuleController.this;
                    int n = treeSubModuleController.nodeCount;
                    treeSubModuleController.nodeCount = n + 1;
                    new TreeNode(node, (Object)stringBuilder.append(n).toString());
                }
            }
        });
        this.buttonRename.setText("&Rename");
        this.buttonRename.addListener(new IActionListener(){

            public void callback() {
                String newValue;
                ITreeNode node = (ITreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null && (newValue = TreeSubModuleController.this.getNewValue(node.getValue())) != null) {
                    node.setValue((Object)newValue);
                }
            }
        });
        buttonDelete.setText("&Delete");
        buttonDelete.addListener(new IActionListener(){

            public void callback() {
                ITreeNode parent;
                ITreeNode node = (ITreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                ITreeNode iTreeNode = parent = node != null ? node.getParent() : null;
                if (parent != null) {
                    List children = parent.getChildren();
                    children.remove(node);
                    parent.setChildren(children);
                }
            }
        });
        buttonExpand.setText("E&xpand");
        buttonExpand.addListener(new IActionListener(){

            public void callback() {
                ITreeNode node = (ITreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    TreeSubModuleController.this.tree.expand((Object)node);
                }
            }
        });
        buttonCollapse.setText("&Collapse");
        buttonCollapse.addListener(new IActionListener(){

            public void callback() {
                ITreeNode node = (ITreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    TreeSubModuleController.this.tree.collapse((Object)node);
                }
            }
        });
        buttonDisable.setText("D&isable");
        buttonDisable.addListener(new IActionListener(){

            public void callback() {
                TreeNode node = (TreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    TreeSubModuleController.this.setEnabledRec(node, false);
                    TreeSubModuleController.this.tree.clearSelection();
                }
            }
        });
        buttonEnable.setText("&Enable");
        buttonEnable.addListener(new IActionListener(){

            public void callback() {
                TreeNode node = (TreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    TreeSubModuleController.this.setEnabledRec(node, true);
                }
            }
        });
        buttonHide.setText("&Hide");
        buttonHide.addListener(new IActionListener(){

            public void callback() {
                TreeNode node = (TreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    node.setVisible(false);
                }
            }
        });
        buttonShow.setText("Sho&w children");
        buttonShow.addListener(new IActionListener(){

            public void callback() {
                TreeNode node = (TreeNode)TreeSubModuleController.this.tree.getSingleSelectionObservable().getValue();
                if (node != null) {
                    for (ITreeNode child : node.getChildren()) {
                        ((TreeNode)child).setVisible(true);
                    }
                }
            }
        });
        final IObservableValue viewerSelection = this.tree.getSingleSelectionObservable();
        NotNullValue hasSelection = new NotNullValue(viewerSelection);
        ComputedValue hasNonRootSelection = new ComputedValue(Boolean.TYPE){

            protected Object calculate() {
                boolean result = false;
                Object node = viewerSelection.getValue();
                if (node instanceof ITreeNode) {
                    result = ((ITreeNode)node).getParent() != null;
                }
                return result;
            }
        };
        DataBindingContext dbc = new DataBindingContext();
        this.bindEnablementToValue(dbc, (IRidget)buttonAddChild, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonAddSibling, (IObservableValue)hasNonRootSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonDelete, (IObservableValue)hasNonRootSelection);
        this.bindEnablementToValue(dbc, (IRidget)this.buttonRename, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonExpand, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonCollapse, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonEnable, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonDisable, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonHide, (IObservableValue)hasSelection);
        this.bindEnablementToValue(dbc, (IRidget)buttonShow, (IObservableValue)hasSelection);
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        dbc.bindValue(BeansObservables.observeValue((Object)ridget, (String)"enabled"), value, null, null);
    }

    private TreeNode[] createTreeInput() {
        TreeNode root = new TreeNode((Object)"root");
        TreeNode groupA = new TreeNode((ITreeNode)root, (Object)"group a");
        new TreeNode((ITreeNode)groupA, (Object)"a_child_1");
        new TreeNode((ITreeNode)groupA, (Object)"a_child_2");
        new TreeNode((ITreeNode)groupA, (Object)"a_child_3");
        TreeNode groupB = new TreeNode((ITreeNode)root, (Object)"group b");
        new TreeNode((ITreeNode)groupB, (Object)"b_child_1");
        new TreeNode((ITreeNode)groupB, (Object)"b_child_2");
        new TreeNode((ITreeNode)groupB, (Object)"b_child_3");
        TreeNode groupC = new TreeNode((ITreeNode)root, (Object)"group c");
        new TreeNode((ITreeNode)groupC, (Object)"c_child_1");
        new TreeNode((ITreeNode)groupC, (Object)"c_child_2");
        new TreeNode((ITreeNode)groupC, (Object)"c_child_3");
        return new TreeNode[]{root};
    }

    private String getNewValue(Object oldValue) {
        String newValue = null;
        if (oldValue != null) {
            Shell shell = ((Button)this.buttonRename.getUIControl()).getShell();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    boolean isValid = newText.trim().length() > 0;
                    return isValid ? null : "Name cannot be empty!";
                }
            };
            InputDialog dialog = new InputDialog(shell, "Rename", "Enter a new name:", String.valueOf(oldValue), validator);
            int result = dialog.open();
            if (result == 0) {
                newValue = dialog.getValue();
            }
        }
        return newValue;
    }

    private void setEnabledRec(TreeNode node, boolean isEnabled) {
        node.setEnabled(isEnabled);
        for (ITreeNode child : node.getChildren()) {
            this.setEnabledRec((TreeNode)child, isEnabled);
        }
    }

    private static final class NotNullValue
    extends ComputedValue {
        private final IObservableValue value;

        private NotNullValue(IObservableValue value) {
            super(Boolean.TYPE);
            this.value = value;
        }

        protected Object calculate() {
            return this.value.getValue() != null;
        }
    }
}

