/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.ping.client.controllers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.riena.core.ping.IPingable;
import org.eclipse.riena.core.ping.PingResult;
import org.eclipse.riena.core.ping.PingVisitor;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.example.ping.client.model.NoPingableFound;
import org.eclipse.riena.example.ping.client.model.PingResultTreeNode;
import org.eclipse.riena.example.ping.client.model.PingableTreeNode;
import org.eclipse.riena.example.ping.client.nls.Messages;
import org.eclipse.riena.example.ping.client.ridgets.ProgressbarRidget;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.uiprocess.UIProcess;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.tree2.ITreeNode;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SonarController
extends SubModuleController {
    private static final String STACKFRAME_ICON = "stackframe.gif";
    private static final String NEXT_ERROR_ICON = "select_next.gif";
    private static final String PREVIOUS_ERROR_ICON = "select_prev.gif";
    private static final String STOP_ICON = "stop.gif";
    private static final String START_ICON = "relaunch.gif";
    private ProgressbarRidget progressRidget;
    private IActionRidget startAction;
    private IActionRidget stopAction;
    private IActionRidget previousErrorAction;
    private IActionRidget nextErrorAction;
    private ITreeRidget treeRidget;
    private ITextRidget stackTraceTextRidget;
    private ILabelRidget pingLabel;
    private ILabelRidget failureLabel;
    private ILabelRidget failureMessageIconRidget;
    private ILabelRidget failureMessageTextRidget;
    private PingableTreeNode[] rootNodes;
    private Cursor oldCursor;

    public void configureRidgets() {
        super.configureRidgets();
        this.stackTraceTextRidget = (ITextRidget)this.getRidget("stackTraceText");
        this.treeRidget = (ITreeRidget)this.getRidget("sonarTree");
        this.treeRidget.addSelectionListener(new ISelectionListener(){

            public void ridgetSelected(SelectionEvent event) {
                SonarController.this.treeNodeSelected();
            }
        });
        this.failureMessageIconRidget = (ILabelRidget)this.getRidget("failureMessageIconLabel");
        this.failureMessageIconRidget.setIcon(STACKFRAME_ICON);
        this.failureMessageIconRidget.setEnabled(false);
        this.failureMessageTextRidget = (ILabelRidget)this.getRidget("failureMessageTextLabel");
        this.failureMessageTextRidget.setEnabled(false);
        this.progressRidget = (ProgressbarRidget)this.getRidget("progressBar");
        this.progressRidget.setBackground(Display.getCurrent().getSystemColor(1));
        this.progressRidget.setForeground(Display.getCurrent().getSystemColor(5));
        this.progressRidget.updateFromModel();
        this.startAction = (IActionRidget)this.getRidget("startButton");
        this.startAction.setIcon(START_ICON);
        this.startAction.setToolTipText(Messages.start_tooltip);
        this.startAction.addListener(new IActionListener(){

            public void callback() {
                SonarController.this.startSonar();
            }
        });
        this.stopAction = (IActionRidget)this.getRidget("stopButton");
        this.stopAction.setIcon(STOP_ICON);
        this.stopAction.setToolTipText(Messages.stop_tooltip);
        this.stopAction.setEnabled(false);
        this.previousErrorAction = (IActionRidget)this.getRidget("previousErrorButton");
        this.previousErrorAction.setIcon(PREVIOUS_ERROR_ICON);
        this.previousErrorAction.setToolTipText(Messages.previous_error_tooltip);
        this.previousErrorAction.setEnabled(false);
        this.previousErrorAction.addListener(new IActionListener(){

            public void callback() {
                SonarController.this.selectPreviousFailure();
            }
        });
        this.nextErrorAction = (IActionRidget)this.getRidget("nextErrorButton");
        this.nextErrorAction.setIcon(NEXT_ERROR_ICON);
        this.nextErrorAction.setToolTipText(Messages.next_error_tooltip);
        this.nextErrorAction.setEnabled(false);
        this.nextErrorAction.addListener(new IActionListener(){

            public void callback() {
                SonarController.this.selectNextFailure();
            }
        });
        this.pingLabel = (ILabelRidget)this.getRidget("pingLabel");
        this.failureLabel = (ILabelRidget)this.getRidget("failedLabel");
    }

    public void afterBind() {
        super.afterBind();
        ((Tree)this.treeRidget.getUIControl()).addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent e) {
                if (e.item.getData() instanceof PingResultTreeNode) {
                    final PingResultTreeNode node = (PingResultTreeNode)((Object)e.item.getData());
                    ((Control)e.getSource()).getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            List children = node.getChildren();
                            if (children != null) {
                                for (ITreeNode iTreeNode : children) {
                                    SonarController.this.treeRidget.refresh((Object)iTreeNode);
                                }
                            }
                        }
                    });
                }
            }

            public void treeCollapsed(TreeEvent e) {
                Nop.reason((String)"nothing to do here");
            }
        });
    }

    protected void updateUI() {
        this.updateNextPreviousButtons();
        this.updateAllRidgetsFromModel();
    }

    protected PingResultTreeNode getSelectedTreeNode() {
        List selection = this.treeRidget.getSelection();
        if (selection.size() > 0) {
            return (PingResultTreeNode)((Object)selection.get(0));
        }
        return null;
    }

    protected void treeNodeSelected() {
        boolean hasFailure = false;
        PingResultTreeNode selectedNode = this.getSelectedTreeNode();
        if (selectedNode != null && selectedNode.getPingResult() != null) {
            this.stackTraceTextRidget.setText(selectedNode.getPingResult().getPingFailure());
            hasFailure = selectedNode.getPingResult().hasPingFailed();
        }
        this.failureMessageIconRidget.setEnabled(hasFailure);
        this.failureMessageTextRidget.setEnabled(hasFailure);
        this.updateNextPreviousButtons();
    }

    protected void updateNextPreviousButtons() {
        this.nextErrorAction.setEnabled(this.getFailureNode(SearchDirection.next) != null);
        this.previousErrorAction.setEnabled(this.getFailureNode(SearchDirection.previous) != null);
    }

    protected void selectNextFailure() {
        PingResultTreeNode nextFailureNode = this.getFailureNode(SearchDirection.next);
        if (nextFailureNode != null) {
            this.treeRidget.setSelection((Object)nextFailureNode);
        }
        this.updateNextPreviousButtons();
    }

    protected void selectPreviousFailure() {
        PingResultTreeNode nextFailureNode = this.getFailureNode(SearchDirection.previous);
        if (nextFailureNode != null) {
            this.treeRidget.setSelection((Object)nextFailureNode);
        }
        this.updateNextPreviousButtons();
    }

    private PingResultTreeNode getFailureNode(SearchDirection searchDirection) {
        int start;
        PingResultTreeNode selectedTreeNode = this.getSelectedTreeNode();
        List<PingResultTreeNode> nodes = this.flattenTree();
        if (nodes.size() == 0) {
            return null;
        }
        int end = nodes.size();
        int increment = 1;
        if (searchDirection == SearchDirection.previous) {
            end = 0;
            increment = -1;
        }
        start = (start = nodes.indexOf((Object)selectedTreeNode)) < 0 ? (searchDirection == SearchDirection.next ? 0 : nodes.size() - 1) : (start += increment);
        int i = start;
        while (i != end) {
            if (i > nodes.size() || i < 0) {
                return null;
            }
            PingResultTreeNode currentNode = nodes.get(i);
            if (currentNode.hasPingFailed()) {
                return currentNode;
            }
            i += increment;
        }
        return null;
    }

    protected List<PingResultTreeNode> flattenTree() {
        PingableTreeNode[] nodes = this.getRootNodes();
        if (nodes == null || nodes.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<PingResultTreeNode> result = new ArrayList<PingResultTreeNode>();
        PingableTreeNode[] pingableTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            PingableTreeNode current = pingableTreeNodeArray[n2];
            this.flattenTree(current, result);
            ++n2;
        }
        return result;
    }

    private void flattenTree(PingResultTreeNode current, List<PingResultTreeNode> result) {
        result.add(current);
        List children = current.getChildren();
        for (ITreeNode child : children) {
            this.flattenTree((PingResultTreeNode)child, result);
        }
    }

    protected PingableTreeNode[] getRootNodes() {
        return this.rootNodes;
    }

    protected void setRootNodes(PingableTreeNode[] nodes) {
        this.rootNodes = nodes;
        this.treeRidget.bindToModel((Object[])nodes, PingResultTreeNode.class, "children", "parent", "label", null, null, "icon", "icon");
        this.treeRidget.updateFromModel();
    }

    protected void startSonar() {
        SonarUIProcess process = new SonarUIProcess();
        process.start();
    }

    protected PingableTreeNode[] createRootNodes(List<IPingable> pingableServices) {
        PingableTreeNode[] result = new PingableTreeNode[pingableServices.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = new PingableTreeNode(pingableServices.get(i));
            ++i;
        }
        return result;
    }

    protected List<IPingable> getPingableServices() {
        BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        ServiceReference[] allServiceReferences = null;
        try {
            allServiceReferences = context.getAllServiceReferences(null, null);
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("This should never happen since we do not use a filter?!?", e);
        }
        if (allServiceReferences == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IPingable> result = new ArrayList<IPingable>();
        ServiceReference[] serviceReferenceArray = allServiceReferences;
        int n = allServiceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference serviceReference = serviceReferenceArray[n2];
            Object service = context.getService(serviceReference);
            if (service instanceof IPingable) {
                result.add((IPingable)service);
            }
            ++n2;
        }
        if (result.isEmpty()) {
            result.add(new NoPingableFound());
        }
        return result;
    }

    protected void setShowHourGlassCursor(boolean show) {
        Control uiControl = (Control)this.getWindowRidget().getUIControl();
        if (show) {
            this.oldCursor = uiControl.getCursor();
            Cursor waitCursor = uiControl.getDisplay().getSystemCursor(1);
            uiControl.setCursor(waitCursor);
        } else if (this.oldCursor != null) {
            uiControl.setCursor(this.oldCursor);
            this.oldCursor = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SearchDirection {
        previous,
        next;

    }

    private class SonarUIProcess
    extends UIProcess {
        private int pinged;
        private int pingedRootNodes;
        private volatile boolean canceled;
        private int failureCount;
        private boolean endRun;
        private PingResultTreeNode currentNode;
        private boolean expand;
        private IActionListener stopActionListener;

        public SonarUIProcess() {
            super(Messages.sonar, false);
            this.pinged = 0;
            this.pingedRootNodes = 0;
            this.failureCount = 0;
            this.expand = false;
            this.stopActionListener = new IActionListener(){

                public void callback() {
                    SonarUIProcess.this.canceled = true;
                    SonarUIProcess.this.end();
                }
            };
        }

        public void initialUpdateUI(int totalWork) {
            List<IPingable> pingableServices = SonarController.this.getPingableServices();
            PingableTreeNode[] nodes = SonarController.this.createRootNodes(pingableServices);
            SonarController.this.setRootNodes(nodes);
            SonarController.this.progressRidget.setForeground(Display.getCurrent().getSystemColor(5));
            SonarController.this.progressRidget.setMinimum(0);
            SonarController.this.progressRidget.setMaximum(nodes.length);
            SonarController.this.progressRidget.setSelection(this.pinged);
            SonarController.this.stackTraceTextRidget.setText("");
            SonarController.this.pingLabel.setText(Integer.toString(this.pinged));
            SonarController.this.failureLabel.setText(Integer.toString(this.failureCount));
            SonarController.this.stopAction.addListener(this.stopActionListener);
            SonarController.this.stopAction.setEnabled(true);
            SonarController.this.startAction.setEnabled(false);
            SonarController.this.nextErrorAction.setEnabled(false);
            SonarController.this.previousErrorAction.setEnabled(false);
            SonarController.this.failureMessageIconRidget.setEnabled(false);
            SonarController.this.failureMessageTextRidget.setEnabled(false);
            SonarController.this.setShowHourGlassCursor(false);
        }

        public boolean runJob(IProgressMonitor monitor) {
            PingableTreeNode[] pingableTreeNodeArray = SonarController.this.getRootNodes();
            int n = pingableTreeNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                PingableTreeNode pingableNode = pingableTreeNodeArray[n2];
                if (this.canceled) break;
                PingVisitor visitor = new PingVisitor();
                visitor = visitor.ping(pingableNode.getPingable());
                if (this.canceled) break;
                List pingResults = visitor.getPingResults();
                ++this.pinged;
                ++this.pingedRootNodes;
                PingResult pingResult = (PingResult)pingResults.get(0);
                pingableNode.setPingResult(pingResult);
                if (pingResult.hasPingFailed()) {
                    ++this.failureCount;
                }
                this.notifyUpdateUI();
                this.createChildNodes(pingableNode);
                monitor.worked(this.pinged);
                this.notifyUpdateUI();
                ++n2;
            }
            return true;
        }

        private void createChildNodes(PingResultTreeNode parent) {
            this.currentNode = parent;
            this.expand = true;
            this.notifyUpdateUI();
            PingResult pingResult = parent.getPingResult();
            Iterable nestedResults = pingResult.getNestedResults();
            boolean failed = false;
            for (PingResult nested : nestedResults) {
                ++this.pinged;
                PingResultTreeNode child = new PingResultTreeNode((ITreeNode)parent, nested.getPingableName());
                child.setPingResult(nested);
                if (nested.hasPingFailed()) {
                    ++this.failureCount;
                    failed = true;
                }
                this.createChildNodes(child);
            }
            this.currentNode = parent;
            this.expand = failed;
            this.notifyUpdateUI();
        }

        public void updateUi() {
            if (this.canceled) {
                return;
            }
            if (this.currentNode != null) {
                if (this.expand) {
                    SonarController.this.treeRidget.expand((Object)this.currentNode);
                } else {
                    SonarController.this.treeRidget.collapse((Object)this.currentNode);
                }
            }
            SonarController.this.treeRidget.updateFromModel();
            if (this.failureCount > 0) {
                SonarController.this.progressRidget.setForeground(Display.getCurrent().getSystemColor(3));
            }
            SonarController.this.progressRidget.setSelection(this.pingedRootNodes);
            SonarController.this.pingLabel.setText(Integer.toString(this.pinged));
            SonarController.this.failureLabel.setText(Integer.toString(this.failureCount));
        }

        public void finalUpdateUI() {
            this.end();
        }

        protected int getTotalWork() {
            if (SonarController.this.getRootNodes() == null) {
                return 0;
            }
            return SonarController.this.getRootNodes().length;
        }

        protected void end() {
            if (this.endRun) {
                return;
            }
            this.endRun = true;
            SonarController.this.stopAction.removeListener(this.stopActionListener);
            SonarController.this.stopAction.setEnabled(false);
            SonarController.this.startAction.setEnabled(true);
            SonarController.this.treeRidget.updateFromModel();
            SonarController.this.updateUI();
            SonarController.this.selectNextFailure();
            SonarController.this.setShowHourGlassCursor(false);
        }
    }
}

