/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.monitor.client.IClientInfoProvider;

public class SimpleClientInfoProvider
implements IClientInfoProvider,
IExecutableExtension {
    public static final String HOST_ADDRESS = "x-host.address";
    public static final String HOST_CANONICALNAME = "x-host.canonicalname";
    public static final String HOST_NAME = "x-host.name";
    private String clientInfo;
    private static final String UNKNOWN = "?";

    public String getClientInfo() {
        return this.clientInfo;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            this.clientInfo = this.getClientInfo(PropertiesUtils.asArray((Object)data));
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    protected String getClientInfo(String[] properties) {
        StringBuilder bob = new StringBuilder();
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            bob.append(property).append('=').append(this.getProperty(property)).append(',');
            ++n2;
        }
        if (bob.length() > 0) {
            bob.setLength(bob.length() - 1);
        }
        return bob.toString();
    }

    protected String getProperty(String property) {
        if (HOST_NAME.equals(property)) {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                return UNKNOWN;
            }
        }
        if (HOST_CANONICALNAME.equals(property)) {
            try {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException unknownHostException) {
                return UNKNOWN;
            }
        }
        if (HOST_ADDRESS.equals(property)) {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                return UNKNOWN;
            }
        }
        return System.getProperty(property, UNKNOWN);
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.monitor.client", message, (Throwable)e));
    }
}

