/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.common;

import java.io.Serializable;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collectible<T extends Serializable>
implements Serializable {
    private final String clientInfo;
    private final String categoryName;
    private final UUID uuid;
    private final long collectionTime;
    private final T payload;
    private static final long serialVersionUID = 1218813380792765109L;

    protected Collectible() {
        this.clientInfo = null;
        this.categoryName = null;
        this.uuid = null;
        this.collectionTime = 0L;
        this.payload = null;
    }

    public Collectible(String clientInfo, String categoryName, T payload) {
        Assert.isTrue((boolean)StringUtils.isGiven((CharSequence)categoryName), (String)"categoryName must not be empty");
        Assert.isNotNull(payload, (String)"payload must not be null");
        this.clientInfo = clientInfo;
        this.categoryName = categoryName;
        this.uuid = UUID.randomUUID();
        this.collectionTime = System.currentTimeMillis();
        this.payload = payload;
    }

    public String getClientInfo() {
        return this.clientInfo;
    }

    public String getCategory() {
        return this.categoryName;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public long getCollectionTime() {
        return this.collectionTime;
    }

    public T getPayload() {
        return this.payload;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Collectible)) {
            return false;
        }
        return this.uuid.equals(((Collectible)obj).uuid);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String toString() {
        return this.toString(true);
    }

    public String toLogString() {
        return this.toString(false);
    }

    private String toString(boolean verbose) {
        StringBuilder bob = new StringBuilder("Collectible: ");
        bob.append("ClientInfo={").append(this.clientInfo).append("},");
        bob.append("Category=").append(this.categoryName).append(',');
        bob.append("Payload (partial)=").append(verbose ? this.payload : this.partial(this.payload));
        return bob.toString();
    }

    private String partial(T payload) {
        String all = payload.toString();
        int cutOff = all.indexOf(10);
        if (cutOff == -1) {
            return all;
        }
        return String.valueOf(all.substring(0, cutOff)) + " (and more ..)";
    }
}

