/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import org.eclipse.riena.ui.swt.lnf.AbstractLnfRenderer;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class EmbeddedBorderRenderer
extends AbstractLnfRenderer {
    private static final int BORDER_WIDTH = 2;
    private boolean active;

    public void paint(GC gc, Object value) {
        super.paint(gc, value);
        RienaDefaultLnf lnf = LnfManager.getLnf();
        Color borderColor = lnf.getColor("EmbeddedTitlebar.passiveBorderColor");
        if (this.isActive()) {
            borderColor = lnf.getColor("EmbeddedTitlebar.activeBorderColor");
        }
        if (!this.isEnabled()) {
            borderColor = lnf.getColor("EmbeddedTitlebar.disabledBorderColor");
        }
        gc.setForeground(borderColor);
        int x = this.getBounds().x + 2;
        int y = this.getBounds().y;
        int w = this.getWidth() - 4;
        gc.drawLine(x, y, x + w, y);
        y = this.getBounds().y + this.getHeight();
        gc.drawLine(x, y, x + w, y);
        x = this.getBounds().x;
        y = this.getBounds().y + 2;
        int h = this.getHeight() - 4;
        gc.drawLine(x, y, x, y + h);
        x = this.getBounds().x + this.getWidth();
        gc.drawLine(x, y, x, y + h);
        x = this.getBounds().x + 1;
        y = this.getBounds().y + 1;
        w = this.getWidth() - 2;
        gc.drawLine(x, y, x + w, y);
        y = this.getBounds().y + this.getHeight() - 1;
        gc.drawLine(x, y, x + w, y);
        x = this.getBounds().x + 1;
        y = this.getBounds().y + 1;
        h = this.getHeight() - 2;
        gc.drawLine(x, y, x, y + h);
        x = this.getBounds().x + this.getWidth() - 1;
        gc.drawLine(x, y, x, y + h);
    }

    public void dispose() {
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private int getHeight() {
        return this.getBounds().height - 1;
    }

    private int getWidth() {
        return this.getBounds().width - 1;
    }

    public Rectangle computeInnerBounds(Rectangle outerBounds) {
        return new Rectangle(outerBounds.x + 2, outerBounds.y + 2, outerBounds.width - 4, outerBounds.height - 4);
    }

    public Rectangle computeOuterBounds(Rectangle innerBounds) {
        return new Rectangle(innerBounds.x - 2, innerBounds.y - 2, innerBounds.width + 4, innerBounds.height + 4);
    }

    public int computeOuterHeight(int innerHeight) {
        return innerHeight + 4;
    }

    public int computeOuterWidth(int innerWidth) {
        return innerWidth + 4;
    }

    public int getBorderWidth() {
        return 2;
    }
}

