/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.marker.Markable;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.ModuleNode;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.swt.binding.InjectSwtViewBindingDelegate;
import org.eclipse.riena.navigation.ui.swt.component.ModuleToolTip;
import org.eclipse.riena.navigation.ui.swt.component.SubModuleToolTip;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.ModuleGroupRenderer;
import org.eclipse.riena.navigation.ui.swt.lnf.renderer.SubModuleTreeItemMarkerRenderer;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleNavigationListener;
import org.eclipse.riena.ui.core.marker.IIconizableMarker;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.swt.ModuleTitleBar;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleView
implements INavigationNodeView<ModuleNode> {
    private static final String WINDOW_RIDGET = "windowRidget";
    private static final LnFUpdater LNF_UPDATER = new LnFUpdater();
    private AbstractViewBindingDelegate binding;
    private Composite parent;
    private Composite body;
    private Tree subModuleTree;
    private ModuleNode moduleNode;
    private boolean pressed;
    private boolean hover;
    private ModuleTitleBar title;
    private BlockManager blockManager;
    private boolean doNotResize;
    private NavigationTreeObserver navigationTreeObserver;
    private ListenerList<IComponentUpdateListener> updateListeners;
    private ModuleGroupNode moduleGroupNode;

    public ModuleView(Composite parent) {
        this.parent = parent;
        this.binding = this.createBinding();
        this.updateListeners = new ListenerList(IComponentUpdateListener.class);
        this.buildView();
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        this.updateListeners.add((Object)listener);
    }

    public void setModuleGroupNode(ModuleGroupNode moduleGroupNode) {
        this.moduleGroupNode = moduleGroupNode;
    }

    public ModuleGroupNode getModuleGroupNode() {
        return this.moduleGroupNode;
    }

    @Override
    public void bind(ModuleNode node) {
        this.moduleNode = node;
        this.navigationTreeObserver = new NavigationTreeObserver();
        this.navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        this.navigationTreeObserver.addListener((IModuleNodeListener)new ModuleListener());
        this.navigationTreeObserver.addListenerTo((IModuleNode)this.moduleNode);
        if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
            IController controller = (IController)node.getNavigationNodeController();
            this.binding.injectRidgets(controller);
            this.binding.bind(controller);
            controller.afterBind();
        }
    }

    public void dispose() {
        this.unbind();
        SwtUtilities.disposeWidget((Widget)this.title);
        SwtUtilities.disposeWidget((Widget)this.getBody());
        SwtUtilities.disposeWidget((Widget)this.getTree());
    }

    public Rectangle getBounds() {
        Rectangle bounds = this.title.getBounds();
        if (this.getNavigationNode().isActivated()) {
            bounds.height += this.getBody().getSize().y;
        }
        return bounds;
    }

    public String getIcon() {
        if (this.getNavigationNode() == null) {
            return null;
        }
        return this.getNavigationNode().getIcon();
    }

    public String getLabel() {
        if (this.getNavigationNode() == null) {
            return null;
        }
        return this.getNavigationNode().getLabel();
    }

    @Override
    public ModuleNode getNavigationNode() {
        return this.moduleNode;
    }

    public int getOpenHeight() {
        ModuleNode navigationNode = this.getNavigationNode();
        if (navigationNode != null && navigationNode.isActivated()) {
            int depth = navigationNode.calcDepth();
            if (depth == 0) {
                return 0;
            }
            int itemHeight = this.getTree().getItemHeight();
            return depth * itemHeight + 1;
        }
        return 0;
    }

    public boolean isActivated() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isActivated();
    }

    public boolean isCloseable() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isClosable();
    }

    public boolean isHover() {
        return this.hover;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public boolean isVisible() {
        if (this.getNavigationNode() == null) {
            return false;
        }
        return this.getNavigationNode().isVisible();
    }

    public void setHover(boolean hover) {
        if (this.hover != hover) {
            this.hover = hover;
            if (!this.parent.isDisposed()) {
                this.parent.redraw();
            }
        }
    }

    public void setPressed(boolean pressed) {
        if (this.pressed != pressed) {
            this.pressed = pressed;
            if (!this.parent.isDisposed()) {
                this.parent.redraw();
            }
        }
    }

    @Override
    public void unbind() {
        if (this.getNavigationNode().getNavigationNodeController() instanceof IController) {
            IController controller = (IController)this.getNavigationNode().getNavigationNodeController();
            this.binding.unbind(controller);
        }
        this.navigationTreeObserver.removeListenerFrom((IModuleNode)this.moduleNode);
        this.moduleNode = null;
    }

    public void updateModuleView() {
        this.prepareUpdate();
        this.getParent().layout();
    }

    public void prepareUpdate() {
        boolean currentActiveState = false;
        if (this.getNavigationNode() != null) {
            currentActiveState = this.getNavigationNode().isActivated();
        }
        if (!SwtUtilities.isDisposed((Widget)this.title)) {
            this.layoutTitle();
            this.title.setWindowActive(currentActiveState);
        }
        if (!SwtUtilities.isDisposed((Widget)this.getBody())) {
            int height;
            if (this.getBody().isVisible() != currentActiveState) {
                this.getBody().setVisible(currentActiveState);
            }
            if (this.getBody().getSize().y != (height = this.getOpenHeight())) {
                FormData formData = new FormData();
                formData.top = new FormAttachment((Control)this.title);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.height = height;
                this.getBody().setLayoutData((Object)formData);
            }
        }
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new InjectSwtViewBindingDelegate();
    }

    protected void createBodyContent(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        this.subModuleTree = new Tree(parent, 0x20000010);
        this.subModuleTree.setLinesVisible(false);
        RienaDefaultLnf lnf = LnfManager.getLnf();
        this.subModuleTree.setFont(lnf.getFont("SubModuleItem.font"));
        this.binding.addUIControl((Object)this.subModuleTree, "tree");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.subModuleTree.setLayoutData((Object)formData);
        this.addListeners();
        new SubModuleToolTip(this.subModuleTree);
        this.setTreeBackGround();
    }

    protected void fireUpdated(INavigationNode<?> node) {
        IComponentUpdateListener[] iComponentUpdateListenerArray = (IComponentUpdateListener[])this.updateListeners.getListeners();
        int n = iComponentUpdateListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IComponentUpdateListener listener = iComponentUpdateListenerArray[n2];
            listener.update(node);
            ++n2;
        }
    }

    public Composite getParent() {
        return this.parent;
    }

    protected ModuleTitleBar getTitle() {
        return this.title;
    }

    protected Tree getTree() {
        return this.subModuleTree;
    }

    protected void resize() {
        if (this.doNotResize) {
            return;
        }
        this.fireUpdated(null);
    }

    protected void setTreeBackGround() {
        this.subModuleTree.setBackground(LnfManager.getLnf().getColor("SubModuleTree.background"));
    }

    Composite getBody() {
        return this.body;
    }

    private void addListeners() {
        this.getTree().addListener(9, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.onTreePaint(event.gc);
            }
        });
        this.getTree().addListener(17, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.handleExpandCollapse(event, true);
            }
        });
        this.getTree().addListener(18, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.handleExpandCollapse(event, false);
            }
        });
        this.getTree().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                ModuleView.this.paintTreeItem(event);
            }
        });
        new ModuleNavigationListener(this.getTree());
    }

    private void blockView(boolean block) {
        if (this.blockManager == null) {
            this.blockManager = new BlockManager();
        }
        if (block) {
            this.blockManager.block();
        } else {
            this.blockManager.unblock();
        }
    }

    private void buildView() {
        this.title = new ModuleTitleBar(this.getParent(), 0);
        this.binding.addUIControl((Object)this.title, WINDOW_RIDGET);
        new ModuleToolTip(this.title);
        this.body = new Composite(this.getParent(), 0x20000000);
        this.createBodyContent(this.body);
        LNF_UPDATER.updateUIControls(this.body, true);
    }

    private boolean clipSubModuleText(GC gc, TreeItem item) {
        boolean clipped = false;
        Rectangle treeBounds = this.getTree().getBounds();
        Rectangle itemBounds = item.getBounds();
        int maxWidth = treeBounds.width - itemBounds.x - 5;
        String longText = this.getItemText(item);
        if (longText != null) {
            String text = SwtUtilities.clipText((GC)gc, (String)longText, (int)maxWidth);
            boolean bl = clipped = !longText.equals(text);
            if (clipped) {
                item.setText(text);
            }
        }
        return clipped;
    }

    private boolean clipSubModuleTexts(GC gc, TreeItem item) {
        TreeItem[] items;
        boolean clipped = this.clipSubModuleText(gc, item);
        TreeItem[] treeItemArray = items = item.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem childItem = treeItemArray[n2];
            if (this.clipSubModuleTexts(gc, childItem)) {
                clipped = true;
            }
            ++n2;
        }
        return clipped;
    }

    private String getItemText(TreeItem item) {
        INavigationNode subModule = (INavigationNode)item.getData();
        if (subModule != null) {
            return subModule.getLabel();
        }
        return item.getText();
    }

    private ModuleGroupRenderer getModuleGroupRenderer() {
        ModuleGroupRenderer renderer = (ModuleGroupRenderer)LnfManager.getLnf().getRenderer("ModuleGroup.renderer");
        if (renderer == null) {
            renderer = new ModuleGroupRenderer();
        }
        return renderer;
    }

    private SubModuleTreeItemMarkerRenderer getTreeItemRenderer() {
        SubModuleTreeItemMarkerRenderer renderer = (SubModuleTreeItemMarkerRenderer)LnfManager.getLnf().getRenderer("SubModuleTreeItemMarker.renderer");
        if (renderer == null) {
            renderer = new SubModuleTreeItemMarkerRenderer();
        }
        return renderer;
    }

    private void handleExpandCollapse(Event event, boolean expand) {
        if (event.item instanceof TreeItem) {
            TreeItem item = (TreeItem)event.item;
            INavigationNode node = (INavigationNode)item.getData();
            node.setExpanded(expand);
        }
        this.resize();
    }

    private void layoutTitle() {
        FormData formData = new FormData();
        int index = this.getModuleGroupNode().getIndexOfChild((INavigationNode)this.getNavigationNode());
        formData.top = index == 0 ? new FormAttachment(0, 0) : (index < 0 ? new FormAttachment(this.getModuleViewBody((IModuleNode)this.getModuleGroupNode().getChild(this.getModuleGroupNode().getChildren().size() - 1)), this.getModuleGroupRenderer().getModuleModuleGap()) : new FormAttachment(this.getModuleViewBody((IModuleNode)this.getModuleGroupNode().getChild(index - 1)), this.getModuleGroupRenderer().getModuleModuleGap()));
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.height = this.title.getSize().y;
        this.title.setLayoutData((Object)formData);
    }

    private Control getModuleViewBody(IModuleNode child) {
        for (ModuleView moduleView : this.getModuleGroupRenderer().getItems()) {
            if (moduleView.getNavigationNode() != child) continue;
            return moduleView.getBody();
        }
        return null;
    }

    private void onTreePaint(GC gc) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = this.getTree().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.clipSubModuleTexts(gc, item);
            ++n2;
        }
    }

    private void paintTreeItem(Event event) {
        if (event.item instanceof TreeItem) {
            SubModuleTreeItemMarkerRenderer renderer = this.getTreeItemRenderer();
            renderer.setBounds(event.x, event.y, event.width, event.height);
            TreeItem item = (TreeItem)event.item;
            SubModuleNode node = (SubModuleNode)item.getData();
            if (node != null) {
                boolean deep = !item.getExpanded();
                Collection<? extends IMarker> markers = this.getAllMarkers((ISubModuleNode)node, deep);
                renderer.setMarkers(markers);
            }
            renderer.paint(event.gc, event.item);
        }
    }

    private Collection<? extends IMarker> getAllMarkers(ISubModuleNode node, boolean deep) {
        if (node == null || !node.isVisible()) {
            return Collections.emptySet();
        }
        HashSet<IMarker> markers = new HashSet<IMarker>();
        this.fillMarkers(node, deep, markers);
        return markers;
    }

    private void fillMarkers(ISubModuleNode node, boolean deep, Set<IMarker> markers) {
        if (!node.isVisible()) {
            return;
        }
        markers.addAll(Markable.getMarkersOfType((Collection)node.getMarkers(), IIconizableMarker.class));
        if (deep) {
            for (ISubModuleNode child : node.getChildren()) {
                this.fillMarkers(child, deep, markers);
            }
        }
    }

    private final class BlockManager {
        private Cursor titleOldCursor;
        private Cursor bodyOldCursor;

        private BlockManager() {
        }

        public void block() {
            this.titleOldCursor = ModuleView.this.title.getCursor();
            ModuleView.this.title.setCursor(this.getWaitCursor());
            ModuleView.this.title.setCloseable(false);
            if (this.disableTitle()) {
                ModuleView.this.title.setEnabled(false);
            }
            this.bodyOldCursor = ModuleView.this.body.getCursor();
            ModuleView.this.body.setCursor(this.getWaitCursor());
            ModuleView.this.subModuleTree.setEnabled(false);
        }

        public void unblock() {
            ModuleView.this.title.setCursor(this.titleOldCursor);
            ModuleView.this.title.setCloseable(ModuleView.this.getNavigationNode().isClosable());
            ModuleView.this.title.setEnabled(ModuleView.this.getNavigationNode().isEnabled());
            ModuleView.this.body.setCursor(this.bodyOldCursor);
            ModuleView.this.subModuleTree.setEnabled(true);
        }

        private boolean disableTitle() {
            ISubApplicationNode subApp = (ISubApplicationNode)ModuleView.this.getNavigationNode().getParentOfType(ISubApplicationNode.class);
            return subApp != null && subApp.isBlocked();
        }

        private Cursor getWaitCursor() {
            return ModuleView.this.parent.getDisplay().getSystemCursor(1);
        }
    }

    private class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void activated(IModuleNode source) {
            super.activated((INavigationNode)source);
            ModuleView.this.updateModuleView();
        }

        public void block(IModuleNode source, boolean block) {
            ModuleView.this.blockView(block);
        }

        public void disposed(IModuleNode source) {
            super.disposed((INavigationNode)source);
            ModuleView.this.dispose();
        }

        public void markerChanged(IModuleNode source, IMarker marker) {
            super.markerChanged((INavigationNode)source, marker);
            ModuleView.this.title.setMarkers(source.getMarkers());
            ModuleView.this.title.redraw();
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void beforeActivated(ISubModuleNode source) {
            Tree tree = ModuleView.this.getTree();
            if (tree.getSelectionCount() == 0 && tree.getItemCount() > 0) {
                TreeItem firstItem = tree.getItem(0);
                tree.select(firstItem);
            }
        }

        public void activated(ISubModuleNode source) {
            ModuleView.this.doNotResize = true;
            this.updateExpanded(source);
            ModuleView.this.doNotResize = false;
            ModuleView.this.resize();
            ModuleView.this.getTree().setFocus();
        }

        public void childAdded(ISubModuleNode source, ISubModuleNode childAdded) {
            ModuleView.this.resize();
        }

        public void childRemoved(ISubModuleNode source, ISubModuleNode childRemoved) {
            ModuleView.this.resize();
        }

        public void labelChanged(ISubModuleNode source) {
            super.labelChanged((INavigationNode)source);
            ModuleView.this.getTree().redraw();
        }

        public void markerChanged(ISubModuleNode source, IMarker marker) {
            ModuleView.this.getTree().redraw();
        }

        private void updateExpanded(ISubModuleNode node) {
            INavigationNode nodeParent = node.getParent();
            if (nodeParent instanceof ISubModuleNode) {
                nodeParent.setExpanded(true);
                this.updateExpanded((ISubModuleNode)nodeParent);
            }
        }

        public void expandedChanged(ISubModuleNode source) {
            super.expandedChanged((INavigationNode)source);
            ModuleView.this.resize();
        }
    }
}

