/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.listener.IModuleNodeListener;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.ModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.ModuleController;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ITreeRidget;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.uiprocess.SwtUISynchronizer;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SWTModuleController
extends ModuleController {
    private ITreeRidget tree;
    private static final String PROPERTY_ENABLED = "enabled";
    private static final String PROPERTY_VISIBLE = "visible";
    private static final String PROPERTY_IMAGE = "icon";
    private static final String PROPERTY_EXPANDED = "expanded";
    private boolean showOneSubTree;

    public SWTModuleController(IModuleNode navigationNode) {
        super(navigationNode);
        this.addListeners();
        RienaDefaultLnf lnf = LnfManager.getLnf();
        this.showOneSubTree = lnf.getBooleanSetting("SubModuleTree.showOneSubTree", false);
    }

    public void setTree(ITreeRidget tree) {
        this.tree = tree;
    }

    public ITreeRidget getTree() {
        return this.tree;
    }

    public void afterBind() {
        super.afterBind();
        this.updateNavigationNodeMarkers();
        this.bindTree();
    }

    private void addListeners() {
        NavigationTreeObserver navigationTreeObserver = new NavigationTreeObserver();
        navigationTreeObserver.addListener((IModuleNodeListener)new ModuleListener());
        navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleListener());
        navigationTreeObserver.addListenerTo((IModuleNode)this.getNavigationNode());
    }

    private void bindTree() {
        this.tree.setRootsVisible(false);
        Object[] roots = this.createTreeRootNodes();
        this.tree.bindToModel(roots, SubModuleNode.class, "children", "parent", "label", PROPERTY_ENABLED, PROPERTY_VISIBLE, PROPERTY_IMAGE, null, PROPERTY_EXPANDED);
        this.tree.setSelectionType(ISelectableRidget.SelectionType.SINGLE);
        this.selectActiveNode();
    }

    private IModuleNode[] createTreeRootNodes() {
        IModuleNode moduleNode = (IModuleNode)this.getNavigationNode();
        return new IModuleNode[]{moduleNode};
    }

    private Display getDisplay() {
        return new SwtUISynchronizer().getDisplay();
    }

    private void runAsync(Runnable op) {
        this.getDisplay().asyncExec(op);
    }

    private void selectActiveNode() {
        this.setSelectedNode(this.getNavigationNode());
    }

    private void showOneSubTree(ISubModuleNode activeNode) {
        if (this.isShowOneSubTree()) {
            this.collapseSibling(activeNode);
            if (!activeNode.isExpanded()) {
                activeNode.setExpanded(true);
            }
        }
    }

    private void collapseSibling(ISubModuleNode node) {
        INavigationNode parent = node.getParent();
        for (INavigationNode sibling : parent.getChildren()) {
            if (sibling != node && sibling.isExpanded()) {
                sibling.setExpanded(false);
            }
            if (!(parent instanceof ISubModuleNode)) continue;
            this.collapseSibling((ISubModuleNode)parent);
        }
    }

    private void setSelectedNode(INavigationNode<?> node) {
        if (node.isActivated() && node != this.getNavigationNode()) {
            this.tree.setSelection(node);
            this.expandAllParents(node);
        }
        for (INavigationNode child : node.getChildren()) {
            this.setSelectedNode(child);
        }
    }

    private void expandAllParents(INavigationNode<?> node) {
        INavigationNode parent = node.getParent();
        while (parent instanceof SubModuleNode) {
            this.tree.expand((Object)parent);
            parent = parent.getParent();
        }
    }

    private boolean isShowOneSubTree() {
        return this.showOneSubTree;
    }

    private class ModuleListener
    extends ModuleNodeListener {
        private ModuleListener() {
        }

        public void childAdded(IModuleNode source, ISubModuleNode childAdded) {
            super.childAdded((INavigationNode)source, (INavigationNode)childAdded);
            if (SWTModuleController.this.tree != null) {
                SWTModuleController.this.tree.updateFromModel();
            }
        }
    }

    private class SubModuleListener
    extends SubModuleNodeListener {
        private SubModuleListener() {
        }

        public void afterActivated(final ISubModuleNode source) {
            SWTModuleController.this.runAsync(new Runnable(){

                public void run() {
                    SWTModuleController.this.selectActiveNode();
                    SWTModuleController.this.showOneSubTree(source);
                }
            });
        }

        public void expandedChanged(ISubModuleNode source) {
            super.expandedChanged((INavigationNode)source);
            if (SWTModuleController.this.tree != null) {
                if (source.isExpanded()) {
                    SWTModuleController.this.tree.expand((Object)source);
                } else {
                    SWTModuleController.this.tree.collapse((Object)source);
                }
            }
        }

        public void childRemoved(ISubModuleNode source, ISubModuleNode childRemoved) {
            super.childRemoved((INavigationNode)source, (INavigationNode)childRemoved);
            if (SWTModuleController.this.tree != null) {
                if (source.getChildren().size() == 0) {
                    SWTModuleController.this.tree.collapse((Object)source);
                    return;
                }
                SWTModuleController.this.tree.updateFromModel();
            }
        }

        public void childAdded(ISubModuleNode source, ISubModuleNode childAdded) {
            super.childAdded((INavigationNode)source, (INavigationNode)childAdded);
            if (SWTModuleController.this.tree != null) {
                SWTModuleController.this.tree.updateFromModel();
            }
        }
    }
}

