/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.util.List;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.swt.views.IModuleNavigationComponentProvider;
import org.eclipse.riena.navigation.ui.swt.views.ModuleGroupView;
import org.eclipse.riena.navigation.ui.swt.views.ModuleView;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScrollingSupport {
    private static final int SCROLLING_STEP = 20;
    private IModuleNavigationComponentProvider navigationComponentProvider;
    private ScrollControlComposite scrollControlComposite;
    private int scrolledCompositeOffset = 0;

    public ScrollingSupport(Composite parent, int flags, IModuleNavigationComponentProvider navigationComponentProvider) {
        this.navigationComponentProvider = navigationComponentProvider;
        this.scrollControlComposite = new ScrollControlComposite(parent, flags);
        this.setBodyCompositeOffset(0);
        this.initMouseWheelObserver(this.navigationComponentProvider.getNavigationComponent());
    }

    public void scroll() {
        this.scrollControlComposite.setVisible(this.mayScroll());
        this.scrollToActive();
    }

    public Composite getScrollComposite() {
        return this.scrollControlComposite;
    }

    private void initMouseWheelObserver(Composite navigationComponent) {
        final Display display = navigationComponent.getDisplay();
        final MouseWheelAdapter wheelAdapter = new MouseWheelAdapter();
        display.addFilter(37, (Listener)wheelAdapter);
        navigationComponent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                display.removeFilter(37, (Listener)wheelAdapter);
            }
        });
    }

    private void scrollUp(int pixels) {
        int offset = Math.min(this.scrolledCompositeOffset + pixels, 0);
        this.setBodyCompositeOffset(offset);
    }

    private void scrollDown(int pixels) {
        int offset = Math.max(this.getNavigationComponentHeight() - this.getScrolledComponentHeight(), this.scrolledCompositeOffset - pixels);
        this.setBodyCompositeOffset(offset);
    }

    private void scrollToActive() {
        if (!this.mayScroll()) {
            this.resetScrolling();
            return;
        }
        INavigationNode<?> activeNode = this.getActiveNode();
        if (!this.scrollTo(activeNode)) {
            this.ensureFilledToBottom();
        }
    }

    private boolean scrollTo(INavigationNode<?> activeNode) {
        boolean result = false;
        if (activeNode instanceof IModuleGroupNode) {
            ModuleGroupView view = this.navigationComponentProvider.getModuleGroupViewForNode((IModuleGroupNode)activeNode);
            result = this.scrollTo(view, view);
        } else if (activeNode instanceof IModuleNode) {
            result = this.scrollTo((IModuleNode)activeNode);
        } else if (activeNode instanceof ISubModuleNode) {
            IModuleNode module = (IModuleNode)activeNode.getParent();
            result = this.scrollTo(module);
        }
        return result;
    }

    private boolean scrollTo(IModuleNode module) {
        boolean result = false;
        if (module != null) {
            boolean isClosed;
            ModuleView moduleView = this.navigationComponentProvider.getModuleViewForNode(module);
            if (moduleView == null) {
                return result;
            }
            boolean bl = isClosed = moduleView.getOpenHeight() == 0;
            if (isClosed) {
                result = this.scrollTo((Composite)moduleView.getTitle(), moduleView.getBody());
            } else {
                int moduleHeight = moduleView.getParent().getSize().y;
                if (moduleHeight < this.getNavigationComponentHeight()) {
                    result = this.scrollTo((Composite)moduleView.getTitle(), moduleView.getBody());
                }
                result = result || this.scrollTo(moduleView.getTree());
            }
        }
        return result;
    }

    private boolean scrollTo(Composite topComp, Composite bottomComp) {
        int compBottomEdge = bottomComp.toDisplay((int)0, (int)bottomComp.getSize().y).y;
        boolean result = this.scrollToBottom(compBottomEdge);
        int compTopEdge = topComp.toDisplay((int)0, (int)0).y;
        result = result || this.scrollToTop(compTopEdge);
        return result;
    }

    private boolean scrollTo(Tree tree) {
        boolean result = false;
        if (tree.getSelectionCount() > 0) {
            TreeItem item = tree.getSelection()[0];
            Rectangle itemBounds = item.getBounds();
            int treeBottomEdge = tree.toDisplay((int)itemBounds.x, (int)(itemBounds.y + tree.getItemHeight())).y;
            result = this.scrollToBottom(treeBottomEdge);
            int treeTopEdge = tree.toDisplay((int)itemBounds.x, (int)itemBounds.y).y;
            result = result || this.scrollToTop(treeTopEdge);
        }
        return result;
    }

    private boolean scrollToBottom(int bottomEdgeToDisplay) {
        boolean scroll;
        int bottomEdge = this.getNavigationComponent().toDisplay((int)0, (int)this.getNavigationComponentHeight()).y;
        boolean bl = scroll = bottomEdgeToDisplay > bottomEdge;
        if (scroll) {
            this.scrollDown(bottomEdgeToDisplay - bottomEdge);
        }
        return scroll;
    }

    private boolean scrollToTop(int topEdgeToDisplay) {
        boolean scroll;
        int topEdge = this.getNavigationComponent().toDisplay((int)0, (int)0).y;
        boolean bl = scroll = topEdgeToDisplay < topEdge;
        if (scroll) {
            this.scrollUp(topEdge - topEdgeToDisplay);
        }
        return scroll;
    }

    private INavigationNode<?> getActiveNode() {
        IModuleGroupNode group = this.navigationComponentProvider.getActiveModuleGroupNode();
        IModuleNode module = null;
        ISubModuleNode submodule = null;
        if (group != null) {
            for (IModuleNode candidate : group.getChildren()) {
                if (!candidate.isActivated()) continue;
                module = candidate;
                break;
            }
        }
        if (module != null) {
            submodule = this.getActiveSubModuleNode(module.getChildren());
        }
        return submodule != null ? submodule : (module != null ? module : group);
    }

    private ISubModuleNode getActiveSubModuleNode(List<ISubModuleNode> nodes) {
        ISubModuleNode result = null;
        for (ISubModuleNode candidate : nodes) {
            if (!candidate.isActivated()) continue;
            ISubModuleNode activeChild = this.getActiveSubModuleNode(candidate.getChildren());
            result = activeChild != null ? activeChild : candidate;
            break;
        }
        return result;
    }

    private boolean mayScroll() {
        int navigationComponentHeight = this.getNavigationComponentHeight();
        return this.getScrolledComponentHeight() > navigationComponentHeight && navigationComponentHeight > 0;
    }

    private void ensureFilledToBottom() {
        int bodyBottomY = this.scrolledCompositeOffset + this.getScrolledComponentHeight();
        if (bodyBottomY < this.getNavigationComponentHeight()) {
            this.setBodyCompositeOffset(this.scrolledCompositeOffset + (this.getNavigationComponentHeight() - bodyBottomY));
        }
    }

    private void resetScrolling() {
        this.setBodyCompositeOffset(0);
        this.scrollControlComposite.setVisible(false);
    }

    private Composite getNavigationComponent() {
        return this.navigationComponentProvider.getNavigationComponent();
    }

    private Composite getScrolledComponent() {
        return this.navigationComponentProvider.getScrolledComponent();
    }

    private int getNavigationComponentHeight() {
        return this.getNavigationComponent().getBounds().height;
    }

    private int getScrolledComponentHeight() {
        return this.getScrolledComponent().getBounds().height;
    }

    private void setBodyCompositeOffset(int yScrolledOffset) {
        if (yScrolledOffset != this.scrolledCompositeOffset) {
            this.scrolledCompositeOffset = yScrolledOffset;
            this.updateUI();
        }
    }

    private void updateUI() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, this.scrolledCompositeOffset);
        this.getScrolledComponent().setLayoutData((Object)formData);
        this.getScrolledComponent().getParent().layout();
    }

    private final class MouseWheelAdapter
    implements Listener {
        private int lastEventTime = 0;

        private MouseWheelAdapter() {
        }

        public void handleEvent(Event event) {
            if (ScrollingSupport.this.mayScroll() && this.acceptEvent(event)) {
                this.lastEventTime = event.time;
                Rectangle navigationComponentBounds = ScrollingSupport.this.getNavigationComponent().getBounds();
                Point navigationPtAtDisplay = ScrollingSupport.this.getNavigationComponent().toDisplay(0, 0);
                navigationComponentBounds.x = navigationPtAtDisplay.x;
                navigationComponentBounds.y = navigationPtAtDisplay.y;
                if (event.widget instanceof Control) {
                    Control widget = (Control)event.widget;
                    Point evtPt = widget.toDisplay(event.getBounds().x, event.getBounds().y);
                    if (navigationComponentBounds.contains(evtPt.x, evtPt.y)) {
                        if (event.count > 0) {
                            ScrollingSupport.this.scrollUp(20);
                        } else {
                            ScrollingSupport.this.scrollDown(20);
                        }
                    }
                }
            }
        }

        private boolean acceptEvent(Event event) {
            boolean isCurrent = event.time > this.lastEventTime;
            Control control = (Control)event.widget;
            boolean isActive = control.getShell() == this.getActiveShell();
            boolean isVisible = ScrollingSupport.this.getNavigationComponent().isVisible();
            return isCurrent && isActive && isVisible;
        }

        private Shell getActiveShell() {
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            return activeWindow != null ? activeWindow.getShell() : null;
        }
    }

    private final class ScrollControlComposite
    extends Composite {
        private Button upButton;
        private Button downButton;

        public ScrollControlComposite(Composite parent, int style) {
            super(parent, style);
            ScrollingSupport.this.getNavigationComponent().addControlListener((ControlListener)new NavigationResizeListener());
            this.setBackground(LnfManager.getLnf().getColor("Navigation.background"));
            this.initControlButtons();
        }

        private void initControlButtons() {
            this.setLayout((Layout)new FormLayout());
            ScrollDelegation delegationAdaper = new ScrollDelegation();
            this.upButton = new Button((Composite)this, 0);
            this.upButton.setBackground(this.getBackground());
            this.upButton.setImage(LnfManager.getLnf().getImage("navigation.scrollup"));
            this.upButton.addSelectionListener((SelectionListener)delegationAdaper);
            this.layoutUpButton();
            this.downButton = new Button((Composite)this, 0);
            this.downButton.setBackground(this.getBackground());
            this.downButton.setImage(LnfManager.getLnf().getImage("navigation.scrollDown"));
            this.downButton.addSelectionListener((SelectionListener)delegationAdaper);
            this.layoutDownButton();
        }

        private void layoutDownButton() {
            FormData fd = new FormData();
            fd.left = new FormAttachment((Control)this.upButton, 1);
            fd.right = new FormAttachment(100, -2);
            fd.height = 12;
            this.downButton.setLayoutData((Object)fd);
        }

        private void layoutUpButton() {
            FormData fd = new FormData();
            fd.left = new FormAttachment(0, 2);
            fd.right = new FormAttachment(50, 0);
            fd.height = 12;
            this.upButton.setLayoutData((Object)fd);
        }

        private final class NavigationResizeListener
        extends ControlAdapter {
            private NavigationResizeListener() {
            }

            public void controlResized(ControlEvent e) {
                ScrollControlComposite.this.setVisible(ScrollingSupport.this.mayScroll());
            }
        }

        private final class ScrollDelegation
        extends SelectionAdapter {
            private ScrollDelegation() {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.getSource() == ScrollControlComposite.this.upButton) {
                    ScrollingSupport.this.scrollUp(20);
                } else {
                    ScrollingSupport.this.scrollDown(20);
                }
            }
        }
    }
}

