/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import org.eclipse.riena.navigation.IUpdateListener;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.NodePositioner;

public class NavigationArgument {
    public static final String CONTEXTKEY_ARGUMENT = "riena.navigation.argument";
    public static final String CONTEXTKEY_PARAMETER = "riena.navigation.parameter";
    private IUpdateListener updateListener = null;
    private Object parameter;
    private NavigationNodeId parentNodeId;
    private String ridgetId;
    private boolean prepareAll;
    private NodePositioner nodePositioner = NodePositioner.ADD_END;

    public NavigationArgument() {
    }

    public NavigationArgument(Object parameter) {
        this();
        this.parameter = parameter;
    }

    public NavigationArgument(Object parameter, String ridgetId) {
        this(parameter);
        this.ridgetId = ridgetId;
    }

    public NavigationArgument(Object parameter, NavigationNodeId parentNodeId) {
        this(parameter);
        this.parentNodeId = parentNodeId;
    }

    public NavigationArgument(Object parameter, NavigationNodeId parentNodeId, String ridgetId) {
        this(parameter, parentNodeId);
        this.ridgetId = ridgetId;
    }

    public NavigationArgument(Object parameter, IUpdateListener updateListener, NavigationNodeId parentNodeId) {
        this(parameter, parentNodeId);
        this.updateListener = updateListener;
    }

    public String getRidgetId() {
        return this.ridgetId;
    }

    public Object getParameter() {
        return this.parameter;
    }

    public NavigationNodeId getParentNodeId() {
        return this.parentNodeId;
    }

    public IUpdateListener getUpdateListener() {
        return this.updateListener;
    }

    public void setPrepareAll(boolean prepareAll) {
        this.prepareAll = prepareAll;
    }

    public boolean isPrepareAll() {
        return this.prepareAll;
    }

    public NodePositioner getNodePositioner() {
        return this.nodePositioner;
    }

    public void setNodePositioner(NodePositioner nodePositioner) {
        this.nodePositioner = nodePositioner;
    }

    public void fireValueChanged(Object parameter) {
        if (this.updateListener == null) {
            return;
        }
        this.updateListener.handleUpdate(parameter);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.nodePositioner == null ? 0 : this.nodePositioner.hashCode());
        result = 31 * result + (this.parameter == null ? 0 : this.parameter.hashCode());
        result = 31 * result + (this.parentNodeId == null ? 0 : this.parentNodeId.hashCode());
        result = 31 * result + (this.prepareAll ? 1231 : 1237);
        result = 31 * result + (this.ridgetId == null ? 0 : this.ridgetId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NavigationArgument other = (NavigationArgument)obj;
        if (this.nodePositioner == null ? other.nodePositioner != null : !this.nodePositioner.equals(other.nodePositioner)) {
            return false;
        }
        if (this.parameter == null ? other.parameter != null : !this.parameter.equals(other.parameter)) {
            return false;
        }
        if (this.parentNodeId == null ? other.parentNodeId != null : !this.parentNodeId.equals(other.parentNodeId)) {
            return false;
        }
        if (this.prepareAll != other.prepareAll) {
            return false;
        }
        if (this.ridgetId == null ? other.ridgetId != null : !this.ridgetId.equals(other.ridgetId)) {
            return false;
        }
        return !(this.updateListener == null ? other.updateListener != null : !this.updateListener.equals(other.updateListener));
    }
}

