/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.util.StringMatcher;
import org.eclipse.riena.navigation.INavigationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NavigationNodeUtility {
    private NavigationNodeUtility() {
    }

    public static String getNodeLongId(INavigationNode<?> node) {
        StringBuilder builder = new StringBuilder();
        NavigationNodeUtility.addToNodeLongId(builder, node);
        return builder.toString();
    }

    private static void addToNodeLongId(StringBuilder builder, INavigationNode<?> node) {
        if (node != null) {
            String id;
            if (node.getNodeId() != null && (id = node.getNodeId().getTypeId()) != null) {
                builder.insert(0, id);
            }
            builder.insert(0, "/");
            NavigationNodeUtility.addToNodeLongId(builder, node.getParent());
        }
    }

    public static INavigationNode<?> findNode(String id, INavigationNode<?> node) {
        return NavigationNodeUtility.findNode(id, node, new IIdClosure(){

            @Override
            public String getId(INavigationNode<?> node) {
                if (node.getNodeId() == null) {
                    return null;
                }
                return node.getNodeId().getTypeId();
            }
        });
    }

    public static INavigationNode<?> findNodeLongId(String id, INavigationNode<?> node) {
        return NavigationNodeUtility.findNode(id, node, new IIdClosure(){

            @Override
            public String getId(INavigationNode<?> node) {
                return NavigationNodeUtility.getNodeLongId(node);
            }
        });
    }

    private static INavigationNode<?> findNode(String id, INavigationNode<?> node, IIdClosure closure) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull(node);
        StringMatcher matcher = new StringMatcher(id);
        String nodeId = closure.getId(node);
        if (matcher.match(nodeId)) {
            return node;
        }
        List<?> children = node.getChildren();
        for (Object child : children) {
            INavigationNode<?> findNode;
            if (!(child instanceof INavigationNode) || (findNode = NavigationNodeUtility.findNode(id, (INavigationNode)child, closure)) == null) continue;
            return findNode;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IIdClosure {
        public String getId(INavigationNode<?> var1);
    }
}

