/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.objecttransaction.delta;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.riena.objecttransaction.delta.AbstractBaseChange;
import org.eclipse.riena.objecttransaction.delta.MultipleChangeEntry;
import org.eclipse.riena.objecttransaction.state.State;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleChange
extends AbstractBaseChange {
    private List<MultipleChangeEntry> changeEntries = new ArrayList<MultipleChangeEntry>();

    public MultipleChange(String relationName) {
        super(relationName);
    }

    public void addEntry(Object childObject) {
        this.changeEntries.add(new MultipleChangeEntry(childObject, State.ADDED));
    }

    public void removeEntry(Object childObject) {
        if (this.changeEntries.size() > 0) {
            int i = this.changeEntries.size() - 1;
            while (i >= 0) {
                MultipleChangeEntry entry = this.changeEntries.get(i);
                if (entry.getChildObject().equals(childObject) && entry.getState().equals(State.ADDED)) {
                    this.changeEntries.remove(i);
                    return;
                }
                --i;
            }
        }
        this.changeEntries.add(new MultipleChangeEntry(childObject, State.REMOVED));
    }

    public List<MultipleChangeEntry> getEntries() {
        return this.changeEntries;
    }

    public String toString() {
        if (this.changeEntries.size() == 0) {
            return "SetChange: <no changes>";
        }
        Object[] array = this.changeEntries.toArray();
        StringBuilder sb = new StringBuilder("SetChange: refName:" + this.getRelationName());
        if (array.length > 1) {
            sb.append("\n");
        }
        int i = 0;
        while (i < array.length) {
            if (array.length > 1) {
                sb.append("---------------->");
            }
            sb.append(" entry[" + i + "]:" + array[i]);
            if (array.length > 1 && i + 1 < array.length) {
                sb.append("\n");
            }
            ++i;
        }
        return sb.toString();
    }
}

