/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.app.client.helloworld.controllers;

import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.sample.app.common.model.Customer;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class CustomerDetailsSubModuleController
extends SubModuleController {
    public static final String RIDGET_ID_CUSTOMER_NUMBER = "customerNumber";
    public static final String RIDGET_ID_LAST_NAME = "lastName";
    public static final String RIDGET_ID_FIRST_NAME = "firstName";
    public static final String RIDGET_ID_BIRTHPLACE = "birthPlace";
    public static final String RIDGET_ID_SAVE = "save";
    public static final String RIDGET_ID_OPEN_OFFERS = "openOffers";

    public CustomerDetailsSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
    }

    public void configureRidgets() {
        super.configureRidgets();
        Customer customer = this.getCustomer();
        ITextRidget customerNumber = (ITextRidget)this.getRidget(RIDGET_ID_CUSTOMER_NUMBER);
        customerNumber.setOutputOnly(true);
        customerNumber.bindToModel((Object)customer, RIDGET_ID_CUSTOMER_NUMBER);
        customerNumber.updateFromModel();
        ITextRidget lastName = (ITextRidget)this.getRidget(RIDGET_ID_LAST_NAME);
        lastName.bindToModel((Object)customer, RIDGET_ID_LAST_NAME);
        lastName.updateFromModel();
        ITextRidget firstName = (ITextRidget)this.getRidget(RIDGET_ID_FIRST_NAME);
        firstName.bindToModel((Object)customer, RIDGET_ID_FIRST_NAME);
        firstName.updateFromModel();
        ITextRidget birthPlace = (ITextRidget)this.getRidget(RIDGET_ID_BIRTHPLACE);
        birthPlace.bindToModel((Object)customer.getBirth(), RIDGET_ID_BIRTHPLACE);
        birthPlace.updateFromModel();
        IActionRidget saveAction = (IActionRidget)this.getRidget(RIDGET_ID_SAVE);
        saveAction.addListener((IActionListener)new SaveCallback());
        saveAction.setText("Save");
        IActionRidget openOffersAction = (IActionRidget)this.getRidget(RIDGET_ID_OPEN_OFFERS);
        openOffersAction.addListener((IActionListener)new OffersCallback());
        openOffersAction.setEnabled(false);
        openOffersAction.setText("Offers");
    }

    private Customer getCustomer() {
        return (Customer)((ISubModuleNode)this.getNavigationNode()).getContext(Customer.class.getName());
    }

    private static class OffersCallback
    implements IActionListener {
        private OffersCallback() {
        }

        public void callback() {
            System.out.println("Offers is not implemented");
        }
    }

    private static class SaveCallback
    implements IActionListener {
        private SaveCallback() {
        }

        public void callback() {
            System.out.println("Save is not implemented");
        }
    }
}

