/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.app.client.helloworld.controllers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.sample.app.client.Activator;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.sample.app.common.model.IHelloWorldService;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;

public class HelloServerSubModuleController
extends SubModuleController {
    private IActionRidget actionFacade;
    private ITextRidget textFacade;
    private IActionListener callback;
    private IHelloWorldService service;
    private MessageBean messageBean;

    public HelloServerSubModuleController(ISubModuleNode navigationNode) {
        super(navigationNode);
        this.startServiceTracker();
        this.callback = new ActionCallback();
    }

    private void startServiceTracker() {
        Inject.service(IHelloWorldService.class).into((Object)this).andStart(Activator.getDefault().getContext());
    }

    public void bind(IHelloWorldService service) {
        this.service = service;
    }

    public void unbind(IHelloWorldService service) {
        if (this.service == service) {
            this.service = null;
        }
    }

    public void afterBind() {
        super.afterBind();
        this.intializeControlBindings();
    }

    private void intializeControlBindings() {
        this.messageBean = new MessageBean();
        this.textFacade.bindToModel((Object)this.messageBean, "message");
        this.textFacade.updateFromModel();
        this.callback = new ActionCallback();
        this.actionFacade.addListener(this.callback);
    }

    public void configureRidgets() {
        this.actionFacade = (IActionRidget)this.getRidget("actionFacade");
        this.textFacade = (ITextRidget)this.getRidget("textFacade");
        this.callback = (IActionListener)this.getRidget("callback");
    }

    private class ActionCallback
    implements IActionListener {
        private ActionCallback() {
        }

        public void callback() {
            if (HelloServerSubModuleController.this.service != null) {
                HelloServerSubModuleController.this.messageBean.setMessage(HelloServerSubModuleController.this.service.getMessage());
                HelloServerSubModuleController.this.textFacade.updateFromModel();
            }
        }
    }

    private static final class MessageBean {
        private String message;
        private PropertyChangeSupport pcSupport = new PropertyChangeSupport(this);

        MessageBean() {
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.pcSupport.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.pcSupport.removePropertyChangeListener(listener);
        }

        public void setMessage(String message) {
            String old = this.message;
            this.message = message;
            this.pcSupport.firePropertyChange("message", old, message);
        }

        public String getMessage() {
            return this.message;
        }
    }
}

