/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common;

import javax.security.auth.Subject;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.security.common.ISubjectChangeListener;
import org.eclipse.riena.security.common.ISubjectHolder;
import org.eclipse.riena.security.common.SubjectChangeEvent;

public class SimpleSubjectHolder
implements ISubjectHolder {
    private Subject subject;
    private final ListenerList<ISubjectChangeListener> subjectChangeListeners = new ListenerList(ISubjectChangeListener.class);

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) {
        Subject old = this.subject;
        this.subject = subject;
        this.notifySubjectChange(this.subject, old);
    }

    private void notifySubjectChange(Subject newSubject, Subject oldSubject) {
        if (this.subjectChangeListeners.size() == 0) {
            return;
        }
        SubjectChangeEvent event = new SubjectChangeEvent(newSubject, oldSubject);
        ISubjectChangeListener[] iSubjectChangeListenerArray = (ISubjectChangeListener[])this.subjectChangeListeners.getListeners();
        int n = iSubjectChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISubjectChangeListener listener = iSubjectChangeListenerArray[n2];
            listener.changed(event);
            ++n2;
        }
    }

    public void addSubjectChangeListener(ISubjectChangeListener listener) {
        if (listener != null) {
            this.subjectChangeListeners.add((Object)listener);
        }
    }

    public void removeSubjectChangeListener(ISubjectChangeListener listener) {
        this.subjectChangeListeners.remove((Object)listener);
    }
}

